/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import java.util.List;
import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.TronUsdt;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.String64;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class TronTrx
implements InfiniteTimer.Callback {
    public static final String TRON = "tron";
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", TronTrx.class.getSimpleName() + "_deposit_address");
    public static final String NETWORK = "trx";
    public static final String CONTRACT = "mfm/send?n=trx&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", TronTrx.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    public static final int TRX_CHECK_INTERVAL_SECONDS = 10;
    public static final Double SUN_IN_TRX = 1000000.0;
    public static final Double TRX_MIN_DEPOSIT = 1.0E-4;
    private static final long LAST_SCANNED_BLOCK = Settings.getLong("deposit", TronTrx.class.getSimpleName() + "_deposit_start_block", 0L);
    BigArray<LongCell> tronTrxLastScannedBlock = new BigArray<LongCell>("deposit", "tronTrxLastScannedBlock", LongCell.class);

    @Override
    public void onTimer() throws Exception {
        String responseStr = Request.get("https://api.trongrid.io/v1/accounts/" + DEPOSIT_ADDRESS + "/transactions", Request.map("limit", "100"), Request.stringMap("TRON-PRO-API-KEY", TronUsdt.TRONGRID_API_KEY));
        TronGridResponse response = (TronGridResponse)Utils.gson.fromJson(responseStr, TronGridResponse.class);
        long lastScannedBlock = this.tronTrxLastScannedBlock.size() > 0L ? this.tronTrxLastScannedBlock.get((long)(this.tronTrxLastScannedBlock.size() - 1L)).value : LAST_SCANNED_BLOCK;
        for (TronTransaction tran : response.data) {
            if (tran.raw_data == null || tran.raw_data.contract == null) continue;
            for (ContractWrapper contract : tran.raw_data.contract) {
                if (!"TransferContract".equals(contract.type)) continue;
                long amountSun = contract.parameter.value.amount;
                double amountTrx = Utils.roundDown((double)amountSun / SUN_IN_TRX);
                if (tran.blockNumber <= lastScannedBlock || !(amountTrx >= TRX_MIN_DEPOSIT)) continue;
                TronTrx.tronTranSuccess(tran.txID, amountTrx);
                this.tronTrxLastScannedBlock.add(new LongCell(tran.blockNumber));
            }
        }
    }

    public static void tronTranSuccess(String transactionId, double amount) {
        String user_address = NodeInit.USER_ADDRESS;
        AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
        if (lock != null) {
            user_address = lock.user_address;
        }
        DepositUtils.tranIdToUserAddress.put(transactionId, new String64(user_address));
        Send.request(CONTRACT, TRON, ADDRESS, user_address, amount, Send.tokenPass(TRON, ADDRESS, PASSWORD), null);
    }

    class TronGridResponse {
        List<TronTransaction> data;

        TronGridResponse() {
        }
    }

    class TronTransaction {
        String txID;
        long blockNumber;
        long block_timestamp;
        RawData raw_data;

        TronTransaction() {
        }
    }

    class RawData {
        List<ContractWrapper> contract;

        RawData() {
        }
    }

    class ContractWrapper {
        String type;
        Parameter parameter;

        ContractWrapper() {
        }
    }

    class Parameter {
        Value value;

        Parameter() {
        }
    }

    class Value {
        long amount;
        String owner_address;
        String to_address;

        Value() {
        }
    }
}

