/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import java.util.List;
import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.String64;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class TronUsdt
implements InfiniteTimer.Callback {
    public static final String TRONGRID_API_KEY = Settings.get("deposit", "trongrid_api_key");
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", TronUsdt.class.getSimpleName() + "_deposit_address");
    public static final String NETWORK = "t";
    public static final String CONTRACT = "mfm/send?n=t&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", TronUsdt.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    public static final int TRON_USDT_CHECK_INTERVAL_SECONDS = 10;
    public static final Double USDT_IN_TRON_USDT = 1000000.0;
    public static final Double TRON_USDT_MIN_DEPOSIT = 1.0E-4;
    private static final long LAST_SCANNED_HEIGHT = Settings.getLong("deposit", TronUsdt.class.getSimpleName() + "_deposit_start_height", 0L);
    BigArray<LongCell> tronUsdtLastScannedHeight = new BigArray<LongCell>("deposit", "tronUsdtLastScannedHeight", LongCell.class);

    @Override
    public void onTimer() throws Exception {
        String responseStr = Request.get("https://api.trongrid.io/v1/accounts/" + DEPOSIT_ADDRESS + "/transactions/trc20", Request.map("limit", "100", "contract_address", "TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t"), Request.stringMap("TRON-PRO-API-KEY", TRONGRID_API_KEY));
        TronGridResponse response = (TronGridResponse)Utils.gson.fromJson(responseStr, TronGridResponse.class);
        long lastScannedHeight = this.tronUsdtLastScannedHeight.size() > 0L ? this.tronUsdtLastScannedHeight.get((long)(this.tronUsdtLastScannedHeight.size() - 1L)).value : LAST_SCANNED_HEIGHT;
        for (TronTransaction tran : response.data) {
            String64 userAddress = DepositUtils.tranIdToUserAddress.get(tran.transaction_id);
            double amount = (double)Long.parseLong(tran.value) / USDT_IN_TRON_USDT;
            if (userAddress != null || tran.block_timestamp <= lastScannedHeight || !(amount >= TRON_USDT_MIN_DEPOSIT)) continue;
            TronUsdt.tronTranSuccess(tran.transaction_id, amount);
            this.tronUsdtLastScannedHeight.add(new LongCell(tran.block_timestamp));
        }
    }

    public static void tronTranSuccess(String transactionId, double amount) {
        String user_address = NodeInit.USER_ADDRESS;
        AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
        if (lock != null) {
            user_address = lock.user_address;
        }
        DepositUtils.tranIdToUserAddress.put(transactionId, new String64(user_address));
        Send.request(CONTRACT, "usdt", ADDRESS, user_address, amount, Send.tokenPass("usdt", ADDRESS, PASSWORD), null);
        TelegramUser user = DepositUtils.getUserByAddress(user_address);
        if (user != null) {
            user.total_deposited += amount;
            DepositUtils.usersByUserId.put("" + user.id, user);
        }
    }

    class TronGridResponse {
        List<TronTransaction> data;

        TronGridResponse() {
        }
    }

    class TronTransaction {
        String transaction_id;
        String value;
        long block_timestamp;
        String from;
        String to;
        TokenInfo token_info;

        TronTransaction() {
        }
    }

    class TokenInfo {
        String symbol;
        String address;
        int decimals;
        String name;

        TokenInfo() {
        }
    }
}

