/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.miner;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vavilon.app.miner.MinerUtils;
import org.vavilon.app.miner.model.MinerAccount;
import org.vavilon.app.telegram.Telegram;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.app.telegram.utils.Format;
import org.vavilon.app.telegram.utils.FormatFront;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Transaction;
import org.vavilon.token.contract.MiningInfo;
import org.vavilon.token.contract.Mint;
import org.vavilon.token.contract.Mint10;
import org.vavilon.token.contract.Mint100;
import org.vavilon.token.contract.Mint20;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class Miner
implements InfiniteTimer.Callback {
    public static final Map<String, MinerAccount> activeMinerAccountsByUserAddress = new HashMap<String, MinerAccount>();
    public static double gasForOneMinting = 3.0E-4;
    public static double minerFor100kHashes = 1.0E-4;

    @Override
    public void onTimer() {
        for (MinerAccount minerAccount : activeMinerAccountsByUserAddress.values()) {
            Miner.calcMinerAccount(minerAccount);
        }
    }

    public static void calcMinerAccount(MinerAccount minerAccount) {
        try {
            String minerAddress;
            String minerPassword;
            block6: {
                if (Utils.isEmpty(minerAccount.domains)) {
                    return;
                }
                minerPassword = Utils.hash(MinerUtils.MINER_PASSWORD + minerAccount.userAddress);
                minerAddress = Send.hashAddress(minerPassword);
                try {
                    Send.request("usdt", minerAddress, MinerUtils.ENERGY_ADDRESS, Format.round(minerAccount.tariff * (double)minerAccount.getDomainList().length), Send.tokenPass("usdt", minerAddress, minerPassword), null);
                }
                catch (Exception e) {
                    activeMinerAccountsByUserAddress.remove(minerAccount.userAddress);
                    List<Transaction> trans = Send.getTrans("usdt", minerAddress, MinerUtils.ENERGY_ADDRESS, 0L, 1L);
                    TelegramUser user = TelegramUtils.getUserByAddress(minerAccount.userAddress);
                    if (trans.size() <= 0 || user == null) break block6;
                    Transaction lastTran = trans.get(0);
                    Telegram.sendToUser(user, "energy_finished", Request.map("time_difference", FormatFront.formatTimeDiff(Utils.currentTimeSec() - lastTran.time, user.language_code), "txid", Format.formatHashShort(lastTran.next_hash)), true);
                }
            }
            for (String domain : minerAccount.getDomainList()) {
                Long nonce = Miner.calcNonceByTariff(domain, 1.0E-4);
                if (nonce == null) continue;
                Miner.sendToUser(domain, minerAddress, minerPassword, nonce);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Long calcNonceByTariff(String domain, double tariff) {
        MiningInfo.Response miningInfo = MiningInfo.request(domain);
        if (miningInfo.last_hash == null) {
            miningInfo.last_hash = "";
        }
        if (miningInfo.difficulty == null) {
            miningInfo.difficulty = 1L;
        }
        int i = 0;
        while ((double)i < tariff * 1.0E9) {
            long nonce = (long)(Math.random() * 1.0E9);
            String str = miningInfo.last_hash + domain + nonce;
            String newHash = Utils.hash(str);
            BigInteger hashNumber = new BigInteger(newHash, 16);
            if ((hashNumber = hashNumber.mod(BigInteger.valueOf(miningInfo.difficulty))).equals(BigInteger.ZERO) || Thread.currentThread().isInterrupted()) {
                return nonce;
            }
            ++i;
        }
        return null;
    }

    static void sendToUser(String domain, String subMinerAddress, String subMinerPassword, Long nonce) {
        MiningInfo.Response info = MiningInfo.request(domain, subMinerAddress);
        if (nonce != null) {
            Mint endpoint = null;
            if ("mfm-contract/mint10".equals(info.bank.delegate)) {
                endpoint = new Mint10();
            } else if ("mfm-contract/mint20".equals(info.bank.delegate)) {
                endpoint = new Mint20();
            } else if ("mfm-contract/mint100".equals(info.bank.delegate)) {
                endpoint = new Mint100();
            }
            if (endpoint != null) {
                endpoint.run(info.bank.delegate, Request.map("domain", domain, "nonce", nonce, "time", "" + Utils.currentTimeSec(), "gas_address", subMinerAddress, "gas_pass", Send.tokenPass("usdt", subMinerAddress, subMinerPassword, info.gas_account.prev_key)));
            }
        }
    }
}

