/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.miner;

import org.vavilon.app.miner.MinerUtils;
import org.vavilon.servers.model.Post;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class Withdrawal
extends Post {
    @Override
    public void run() {
        String domain = this.getRequired("domain");
        String address = this.getRequired("address");
        String minerPassword = Utils.hash(MinerUtils.MINER_PASSWORD + address);
        String minerAddress = Send.hashAddress(minerPassword);
        double balance = Send.getBalanceOrZero(domain, minerAddress);
        if (balance == 0.0) {
            Utils.error("balance is zero");
        }
        Send.request(domain, minerAddress, address, balance, Send.tokenPass(domain, minerAddress, minerPassword), null);
    }

    @Override
    public void commit() {
    }

    public static void request(String domain, String address) {
        new Withdrawal().run(null, Request.map("domain", domain, "address", address));
    }
}

