/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.app.telegram.Telegram;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.SubscriptionCheckResponse;
import org.vavilon.app.telegram.model.TelegramRequest;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.gdb.model.String64;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.Bip39;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class Hook
extends Get {
    @Override
    public Get.Response get() {
        TelegramRequest request = (TelegramRequest)Utils.gson.fromJson(Utils.gson.toJson((Object)this.body), TelegramRequest.class);
        if (request.callback_query != null) {
            try {
                return this.handleCallbackQuery(request.callback_query);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (request.message != null && request.message.text != null) {
            return this.handleMessage(request);
        }
        return null;
    }

    private Get.Response handleMessage(TelegramRequest request) {
        TelegramRequest.Message message = request.message;
        String[] message_parts = request.message.text.split(" ");
        ResponseHook response = new ResponseHook();
        if (message_parts[0].equals("/start")) {
            String address;
            String[] referral_parts;
            response.method = "sendMessage";
            response.chat_id = message.chat.id;
            response.text = Telegram.translateMessage("welcome_to_access_the_bot_subscribe_to_our_channel", request.message.from.language_code);
            response.reply_markup = this.startButtons(request.message.from.language_code);
            Long userId = message.from.id;
            TelegramUser user = TelegramUtils.getUserByUserId(userId);
            if (user == null) {
                user = new TelegramUser();
            }
            if (user.registration_date == null) {
                user.registration_date = Utils.currentTimeSec();
            }
            user.id = userId;
            user.username = message.from.username;
            user.chat_id = message.chat.id;
            user.language_code = message.from.language_code;
            user.first_name = message.from.first_name;
            user.last_name = message.from.last_name;
            if (message_parts.length > 1 && Send.getToken((referral_parts = message_parts[1].split("_with_"))[0]) != null) {
                TelegramUser referral;
                String referral_username;
                user.referral_domain = referral_parts[0];
                String string = referral_username = referral_parts.length > 0 ? referral_parts[1] : "";
                if (Utils.isNotEmpty(referral_username) && !referral_username.equals(user.username) && (referral = TelegramUtils.getUserByUsername(referral_username)) != null) {
                    user.referral_username = referral_username;
                    ++user.referral_count;
                    Telegram.sendToUser(referral, "your_referral_logged_in", Utils.toMap(user), true);
                }
            }
            String seed = Bip39.getRandomSeed(message.chat.id, Bip39.ENG);
            String password = Utils.hash(seed);
            user.address = address = Send.hashAddress(password);
            TelegramUtils.usersByUserId.put("" + userId, user);
            TelegramUtils.userIdByAddress.put(address, new String64("" + userId));
            if (Utils.isNotEmpty(user.username)) {
                TelegramUtils.userIdByUsername.put(user.username, new String64("" + userId));
            }
        }
        return response;
    }

    ReplyMarkup startButtons(String language_code) {
        ReplyMarkup markup = new ReplyMarkup();
        markup.addButton(new TgButton(Telegram.translateMessage("subscribe", language_code), "https://t.me/vavilon_org_news", "url"));
        markup.addButton(new TgButton(Telegram.translateMessage("check_subscription", language_code), "check_sub", "callback_data"));
        return markup;
    }

    private Get.Response handleCallbackQuery(TelegramRequest.CallbackQuery callback_query) throws Exception {
        ResponseCallback response = new ResponseCallback();
        if (callback_query.data.equals("check_sub")) {
            response.method = "editMessageText";
            response.chat_id = callback_query.message.chat.id;
            response.message_id = callback_query.message.message_id;
            String responseStr = Request.post(Telegram.BOT_URL + "/getChatMember", Request.map("chat_id", "@vavilon_org_news", "user_id", callback_query.from.id));
            SubscriptionCheckResponse response1 = (SubscriptionCheckResponse)Utils.gson.fromJson(responseStr, SubscriptionCheckResponse.class);
            if (response1.isSubscribed()) {
                response.text = "\u2705 " + Telegram.translateMessage("thanks_for_subscribe_and_press_play_button_to_start", callback_query.from.language_code);
            } else {
                response.text = "\u274c " + Telegram.translateMessage("you_are_not_subscribed_to_the_channel_yet_please_subscribe_and_enter", callback_query.from.language_code);
                response.reply_markup = this.startButtons(callback_query.from.language_code);
            }
        }
        return response;
    }

    class ResponseHook
    extends Get.Response {
        String method;
        Long chat_id;
        String text;
        ReplyMarkup reply_markup;

        ResponseHook() {
        }
    }

    class ReplyMarkup {
        List<List<TgButton>> inline_keyboard = new ArrayList<List<TgButton>>();

        ReplyMarkup() {
        }

        void addButton(TgButton button) {
            ArrayList<TgButton> lineButton = new ArrayList<TgButton>();
            lineButton.add(button);
            this.inline_keyboard.add(lineButton);
        }
    }

    class TgButton {
        String text;
        String callback_data;
        String url;

        public TgButton(String text, String data, String type) {
            this.text = text;
            if (type.equals("callback_data")) {
                this.callback_data = data;
            } else if (type.equals("url")) {
                this.url = data;
            }
        }
    }

    class ResponseCallback
    extends Get.Response {
        String method;
        Long chat_id;
        Long message_id;
        String text;
        ReplyMarkup reply_markup;

        ResponseCallback() {
        }
    }
}

