/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.app.telegram.model.Message;
import org.vavilon.app.telegram.model.MessageFrequency;
import org.vavilon.app.telegram.model.MessagePriority;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.app.telegram.utils.FormatFront;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.utils.Request;

public class PriceAlert {
    public static Message getMessage(TelegramUser user) {
        try {
            List<Account> accounts = PriceAlert.getTopSubAccounts(user.address);
            Account topAccount = PriceAlert.filterByPriceBorder(accounts);
            return PriceAlert.createMessage(topAccount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Account> getTopSubAccounts(String address) {
        ArrayList<Account> result = new ArrayList<Account>();
        List<Account> accounts = Send.getSubAccounts(address);
        double totalBalance = 0.0;
        for (Account account : accounts) {
            totalBalance += account.balance * account.token.price;
        }
        for (Account account : accounts) {
            double accountTotal;
            if (account.domain.equals("usdt") || !((accountTotal = account.balance * account.token.price) > totalBalance * 0.05)) continue;
            result.add(account);
        }
        return result;
    }

    private static Account filterByPriceBorder(List<Account> accounts) {
        Account topAccount = null;
        for (Account account : accounts) {
            if (!(Math.abs(account.token.price24) > PriceAlert.change24Border(account.token))) continue;
            topAccount = account;
        }
        return topAccount;
    }

    private static Message createMessage(Account account) {
        if (account == null) {
            return null;
        }
        return new Message("price_alert", MessagePriority.DAY_TIME, MessageFrequency.ONE_IN_24H, Request.map("domain", FormatFront.formatDomain(account.token.domain), "price24", FormatFront.formatChange(account.token.price24), "price", FormatFront.formatPrice(account.token.price)));
    }

    private static double change24Border(Token token) {
        if (token.domain.equals("bitcoin")) {
            return 3.0;
        }
        if (token.domain.equals("ethereum")) {
            return 5.0;
        }
        if (token.isWrapped()) {
            return 10.0;
        }
        if (token.volume24 > 1000000.0) {
            return 10.0;
        }
        if (token.volume24 > 100000.0) {
            return 15.0;
        }
        if (token.volume24 > 10000.0) {
            return 30.0;
        }
        return 50.0;
    }
}

