/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.vavilon.app.airdrop.AirdropUtils;
import org.vavilon.app.airdrop.model.Airdrop;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.token.Node;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class Telegram {
    public static final String ROOT_PATH = Settings.get("telegram", "root_path", "java-exchange");
    public static final String TOKEN = Settings.get("telegram", "token");
    public static final String BOT_URL = "https://api.telegram.org/bot" + TOKEN;
    public static final String TME = "https://t.me/";
    private static final String ADMIN_CHAT_ID = "331683369";
    public static final String ADMIN_ADDRESS = Settings.get("telegram", "admin_address");

    public static String translateMessage(String key, String language_code) {
        Map<String, String> translations = Utils.readFileIni(ROOT_PATH + "/message/message/" + language_code + ".js", "message.", " = ", Character.valueOf('\"'));
        if (translations.containsKey(key)) {
            return translations.get(key);
        }
        translations = Utils.readFileIni(ROOT_PATH + "/message/message.js", "message.", " = ", Character.valueOf('\"'));
        String translation = translations.get(key);
        return translation == null ? key : translation;
    }

    public static String translateMessage(String template, String language, List<Object> data) {
        Object[] datalist;
        StringWriter writer;
        Mustache mustache;
        String translation;
        File templateFile = new File(ROOT_PATH + "/message/" + template + "/" + language + ".mustache");
        if (!templateFile.exists()) {
            templateFile = new File(ROOT_PATH + "/message/" + template + ".mustache");
        }
        if (!templateFile.exists()) {
            Utils.error("template does not exists");
        }
        if ((translation = (mustache = new DefaultMustacheFactory(templateFile.getParentFile()).compile(templateFile.getName())).execute((Writer)(writer = new StringWriter()), datalist = data == null ? new Object[]{} : data.toArray()).toString()) == null) {
            translation = template;
        }
        return translation;
    }

    private static void send(String chatId, String template, String language, List<Object> data, boolean withNotification) {
        try {
            if (Utils.isNotEmpty(chatId) && Utils.isNotEmpty(template) && Node.isStarted) {
                String rendered = Telegram.translateMessage(template, language, data);
                if (Node.isDebugMode) {
                    chatId = ADMIN_CHAT_ID;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendToTokenChannel(String domain, String template, Object data) {
        Airdrop airdrop;
        if (Utils.isNotEmpty(domain) && Utils.isNotEmpty(template) && Node.isStarted && (airdrop = AirdropUtils.airdropByDomain.get(domain)) != null && Utils.isNotEmpty(airdrop.telegram)) {
            Telegram.send("@" + airdrop.telegram, template, airdrop.language, Utils.objectList(data), true);
        }
    }

    public static void sendToUser(TelegramUser user, String template, Object data, boolean withNotification) {
        if (user == null) {
            return;
        }
        Telegram.send("" + user.chat_id, template, user.language_code, Utils.objectList(user, data), withNotification);
    }

    public static void sendToAddress(String address, String template, Object data, boolean withNotification) {
        Telegram.sendToUser(TelegramUtils.getUserByAddress(address), template, data, withNotification);
    }

    public static void sendToAddress(String address, String template, Object data) {
        Telegram.sendToAddress(address, template, data, true);
    }

    public static void sendToAdmin(String address, String name, String value, String session) {
        Telegram.sendToAdmin(address, name, value, session, true);
    }

    public static void sendToAdmin(String address, String name, String value, String session, boolean withNotification) {
        Telegram.sendToAddress(ADMIN_ADDRESS, "session_analytics", Request.map("address", address, "name", name, "value", value, "session", session), withNotification);
    }

    public static String getChannelLanguage(String domain) {
        Airdrop airdrop = AirdropUtils.airdropByDomain.get(domain);
        if (airdrop == null) {
            return null;
        }
        return airdrop.language;
    }
}

