/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import org.vavilon.token.utils.Utils;

public class FormatFront {
    private static final String[] colors = new String[]{"#F44336", "#E91E63", "#9C27B0", "#673AB7", "#3F51B5", "#2196F3", "#03A9F4", "#00BCD4", "#009688", "#4CAF50", "#CDDC39", "#FFEB3B", "#FFC107", "#FF9800", "#FF5722"};

    public static double round(double num, int precision) {
        if (precision < 0) {
            precision = 4;
        }
        double factor = Math.pow(10.0, precision);
        return Math.ceil(num * factor) / factor;
    }

    public static double round(double num) {
        return FormatFront.round(num, 4);
    }

    public static String shortNumber(double number, int precision) {
        if (precision < 0) {
            precision = 4;
        }
        number = FormatFront.round(number, precision);
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        if (number >= 1.0E9) {
            return numberFormat.format(FormatFront.round(number / 1.0E9, 1)) + "B";
        }
        if (number >= 1000000.0) {
            return numberFormat.format(FormatFront.round(number / 1000000.0, 1)) + "M";
        }
        if (number >= 100000.0) {
            return numberFormat.format(FormatFront.round(number / 1000.0, 1)) + "K";
        }
        if (number >= 1000.0) {
            return numberFormat.format(FormatFront.round(number, 0));
        }
        return new BigDecimal(number).setScale(precision, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    public static String shortNumber(double number) {
        return FormatFront.shortNumber(number, 4);
    }

    public static String formatSec(long sec) {
        Date d = new Date(sec * 1000L);
        return String.format("%02d:%02d", d.getHours(), d.getMinutes());
    }

    public static String formatPrice(double number, int precision) {
        if (Double.isNaN(number)) {
            number = 0.0;
        }
        return "$" + FormatFront.shortNumber(number, precision);
    }

    public static String formatPrice(double number) {
        return FormatFront.formatPrice(number, 4);
    }

    public static String formatAmount(double number) {
        return FormatFront.shortNumber(number, 4);
    }

    public static String formatAmount(double number, String domain, int precision) {
        if (Double.isNaN(number)) {
            number = 0.0;
        }
        String result = FormatFront.shortNumber(number, precision);
        if (domain != null && !domain.isEmpty()) {
            if (domain.length() > 5) {
                domain = domain.substring(0, 3);
            }
            return result + " " + domain.toUpperCase();
        }
        return result;
    }

    public static String formatAmount(double number, String domain) {
        return FormatFront.formatAmount(number, domain, 4);
    }

    public static String formatDifficulty(double difficulty) {
        return FormatFront.shortNumber(difficulty) + "H";
    }

    public static String formatAddress(String address) {
        if (address == null) {
            return "";
        }
        if (address.length() < 8) {
            return address;
        }
        return address.substring(0, 4) + ".." + address.substring(address.length() - 3);
    }

    public static String formatAddressShort(String address) {
        if (Utils.isEmpty(address)) {
            return "";
        }
        return address.substring(address.length() - 3);
    }

    public static String formatHash(String hash) {
        if (hash == null) {
            return "";
        }
        if (hash.length() < 10) {
            return hash;
        }
        return hash.substring(0, 5) + ".." + hash.substring(hash.length() - 5);
    }

    public static String formatDomainShort(String domain) {
        if (domain == null) {
            return "";
        }
        if (domain.length() > 8) {
            domain = domain.substring(0, 7) + "..";
        }
        return FormatFront.formatDomain(domain);
    }

    public static String formatDomain(String domain) {
        return (domain != null ? domain : "").replace("_", " ").toUpperCase();
    }

    public static String formatChange(double number) {
        if (number == 0.0) {
            return "";
        }
        String str = FormatFront.formatPercent(number, 0);
        if (number > 0.0) {
            str = "+" + str;
        }
        return str;
    }

    public static String formatPercent(double number, int precision) {
        if (number == 0.0 || Double.isNaN(number)) {
            return "0%";
        }
        return FormatFront.round(number, precision > 0 ? precision : 1) + "%";
    }

    public static String formatPercent(double number) {
        return FormatFront.formatPercent(number, 1);
    }

    public static String percentColor(double number) {
        if (Double.isNaN(number)) {
            return "";
        }
        if (number == 0.0) {
            return "text-gray";
        }
        if (number > 0.0) {
            return "text-green";
        }
        return "text-red";
    }

    public static String formatTime(long seconds, String language) {
        long diff = seconds < 1000000000L ? seconds : System.currentTimeMillis() / 1000L - seconds;
        String string = language = Utils.isEmpty(language) ? "en" : language;
        if (language.startsWith("ru")) {
            return FormatFront.formatTimeRussian(diff);
        }
        return FormatFront.formatTimeEnglish(diff);
    }

    public static String formatTimeDiff(long seconds, String language) {
        String ago = " ago";
        String string = language = Utils.isEmpty(language) ? "en" : language;
        if (language.startsWith("ru")) {
            ago = " \u043d\u0430\u0437\u0430\u0434";
        }
        return (FormatFront.formatTime(seconds, language) + ago).toLowerCase();
    }

    private static String formatTimeEnglish(long diff) {
        if (diff < 60L) {
            return String.format("%d %s", diff, diff == 1L ? "second" : "seconds");
        }
        if (diff < 3600L) {
            long minutes = diff / 60L;
            return String.format("%d %s", minutes, minutes == 1L ? "minute" : "minutes");
        }
        if (diff < 86400L) {
            long hours = diff / 3600L;
            return String.format("%d %s", hours, hours == 1L ? "hour" : "hours");
        }
        if (diff < 604800L) {
            long days = diff / 86400L;
            return String.format("%d %s", days, days == 1L ? "day" : "days");
        }
        if (diff < 2592000L) {
            long weeks = diff / 604800L;
            return String.format("%d %s", weeks, weeks == 1L ? "week" : "weeks");
        }
        if (diff < 31536000L) {
            long months = diff / 2592000L;
            return String.format("%d %s", months, months == 1L ? "month" : "months");
        }
        long years = diff / 31536000L;
        return String.format("%d %s", years, years == 1L ? "year" : "years");
    }

    private static String formatTimeRussian(long diff) {
        if (diff < 60L) {
            return String.format("%d %s", diff, FormatFront.getRussianWord(diff, "\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434"));
        }
        if (diff < 3600L) {
            long minutes = diff / 60L;
            return String.format("%d %s", minutes, FormatFront.getRussianWord(minutes, "\u043c\u0438\u043d\u0443\u0442\u0443", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442"));
        }
        if (diff < 86400L) {
            long hours = diff / 3600L;
            return String.format("%d %s", hours, FormatFront.getRussianWord(hours, "\u0447\u0430\u0441", "\u0447\u0430\u0441\u0430", "\u0447\u0430\u0441\u043e\u0432"));
        }
        if (diff < 604800L) {
            long days = diff / 86400L;
            return String.format("%d %s", days, FormatFront.getRussianWord(days, "\u0434\u0435\u043d\u044c", "\u0434\u043d\u044f", "\u0434\u043d\u0435\u0439"));
        }
        if (diff < 2592000L) {
            long weeks = diff / 604800L;
            return String.format("%d %s", weeks, FormatFront.getRussianWord(weeks, "\u043d\u0435\u0434\u0435\u043b\u044e", "\u043d\u0435\u0434\u0435\u043b\u0438", "\u043d\u0435\u0434\u0435\u043b\u044c"));
        }
        if (diff < 31536000L) {
            long months = diff / 2592000L;
            return String.format("%d %s", months, FormatFront.getRussianWord(months, "\u043c\u0435\u0441\u044f\u0446", "\u043c\u0435\u0441\u044f\u0446\u0430", "\u043c\u0435\u0441\u044f\u0446\u0435\u0432"));
        }
        long years = diff / 31536000L;
        return String.format("%d %s", years, FormatFront.getRussianWord(years, "\u0433\u043e\u0434", "\u0433\u043e\u0434\u0430", "\u043b\u0435\u0442"));
    }

    private static String getRussianWord(long number, String form1, String form2, String form5) {
        if ((number = Math.abs(number) % 100L) > 10L && number < 20L) {
            return form5;
        }
        if ((number %= 10L) == 1L) {
            return form1;
        }
        if (number >= 2L && number <= 4L) {
            return form2;
        }
        return form5;
    }

    public static String formatDate(long number) {
        if (number == 0L) {
            return "unset";
        }
        Date date = new Date(number * 1000L);
        Date today = new Date();
        if (today.getYear() == date.getYear() && today.getMonth() == date.getMonth() && today.getDate() == date.getDate()) {
            return "today";
        }
        return String.format("%02d.%02d.%d", date.getDate(), date.getMonth() + 1, date.getYear() + 1900);
    }

    public static String percentFormat(double number) {
        return FormatFront.round(number, 0) + "%";
    }

    public static int random(int from, int to) {
        return (int)(Math.random() * (double)to) + from;
    }

    public static String getColor(String domain) {
        if (domain == null || domain.isEmpty()) {
            return colors[0];
        }
        return colors[domain.charAt(0) % colors.length];
    }

    public static String formatAntiPrice(double number, int precision) {
        if (precision < 0) {
            precision = 2;
        }
        if (number < 1.0) {
            return FormatFront.formatPrice(1.0 / number, precision).substring(1);
        }
        return FormatFront.formatPrice(number, precision).substring(1);
    }

    public static String formatAntiPrice(double number) {
        return FormatFront.formatAntiPrice(number, 2);
    }

    public static String amount(Double value) {
        if (value == null) {
            return "0";
        }
        return FormatFront.shortNumber(value);
    }
}

