/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.charts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.vavilon.charts.model.Candle;
import org.vavilon.gdb.BigArray;
import org.vavilon.token.utils.Utils;

public abstract class Chart {
    static final Map<String, BigArray<Candle>> charts = new ConcurrentHashMap<String, BigArray<Candle>>();
    static final Map<String, Long> periodsSec = new HashMap<String, Long>();
    public static long TIME_MULTIPLICATOR = 1L;

    protected static BigArray<Candle> getChart(String app, String key, String periodName) {
        return charts.computeIfAbsent(key + periodName, k -> new BigArray<Candle>(app + "/chart", key + periodName, Candle.class, periodName.equals("M") ? 2L : Long.MAX_VALUE));
    }

    public static long getPeriodTime(long timeSec, String periodName) {
        long periodSec = periodsSec.get(periodName);
        return timeSec / periodSec * periodSec;
    }

    public static List<Candle> getCandles(String app, String key, String periodName, int count) {
        long periodTime;
        ArrayList<Candle> result = new ArrayList<Candle>();
        BigArray<Candle> chart = Chart.getChart(app, key, periodName);
        if (chart.size() == 0L) {
            return result;
        }
        Candle firstCandle = null;
        Candle lastCandle = null;
        HashMap<Long, Candle> candlesMap = new HashMap<Long, Candle>();
        for (long i = Math.max(chart.size() - (long)count, 0L); i < chart.size(); ++i) {
            Candle candle = chart.get(i);
            if (firstCandle == null) {
                firstCandle = candle;
            }
            lastCandle = candle;
            candlesMap.put(candle.time, candle);
        }
        double lastClose = lastCandle.close;
        long periodSec = periodsSec.get(periodName);
        for (long i = periodTime = Chart.getPeriodTime(Utils.currentTimeSec(), periodName); i >= firstCandle.time && result.size() < count; i -= periodSec) {
            Candle item = (Candle)candlesMap.get(i);
            if (item == null) {
                Candle newCandle = new Candle();
                newCandle.time = (int)i;
                newCandle.low = lastClose;
                newCandle.high = lastClose;
                newCandle.open = lastClose;
                newCandle.close = lastClose;
                result.add(newCandle);
                continue;
            }
            lastClose = item.open;
            result.add(item);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<Candle> getCandlesAccumulate(String app, String key, String periodName, int count) {
        List<Candle> candles = Chart.getCandles(app, key, periodName, count);
        for (Candle candle : candles) {
            candle.open = Utils.round(candle.open);
            candle.close = Utils.round(candle.close);
            candle.high = Utils.round(candle.high);
            candle.low = Utils.round(candle.low);
            candle.value = Utils.round(candle.close - candle.open);
        }
        return candles;
    }

    public static double getChartLastValue(String app, String key) {
        return Chart.getChartLastValue(app, key, "M");
    }

    public static double getChartLastValue(String app, String key, String periodName) {
        Candle last = Chart.getChartLastCandle(app, key, periodName);
        return last == null ? 0.0 : last.close;
    }

    public static Candle getChartLastCandle(String app, String key, String periodName) {
        BigArray<Candle> chart = Chart.getChart(app, key, periodName);
        if (chart.size() == 0L) {
            return null;
        }
        return chart.get(chart.size() - 1L);
    }

    public static double getChartChange1hPercent(String app, String key) {
        return Chart.getChartChangePercent(app, key, "H", 1);
    }

    public static double getChartChange24hPercent(String app, String key) {
        return Chart.getChartChangePercent(app, key, "H", 24);
    }

    private static double getChartChangePercent(String app, String key, String periodName, int count) {
        List<Candle> chart = Chart.getCandles(app, key, periodName, count + 1);
        if (chart.isEmpty()) {
            return 0.0;
        }
        if (chart.size() == 1) {
            Candle candle = chart.get(0);
            if (candle.open == 0.0) {
                return 0.0;
            }
            return (candle.close - candle.open) / candle.open * 100.0;
        }
        double firstClose = chart.get((int)0).close;
        double lastClose = chart.get((int)(chart.size() - 1)).close;
        if (firstClose == 0.0) {
            return 0.0;
        }
        return (lastClose - firstClose) / firstClose * 100.0;
    }

    public static double getChartChange24hTotal(String app, String key) {
        return Chart.getChartChangeTotal(app, key, "H", 24);
    }

    public static double getChart7dTotal(String app, String key) {
        return Chart.getChartChangeTotal(app, key, "D", 7);
    }

    public static double getChartChangeTotal(String app, String key, String periodName, int count) {
        List<Candle> chart = Chart.getCandles(app, key, periodName, count + 1);
        if (chart.size() == 0) {
            return 0.0;
        }
        if (chart.size() == 1) {
            Candle candle = chart.get(0);
            return candle.close - candle.open;
        }
        return chart.get((int)(chart.size() - 1)).close - chart.get((int)0).close;
    }

    static {
        TIME_MULTIPLICATOR = 1L;
        periodsSec.put("M", Math.max(1L, 60L / TIME_MULTIPLICATOR));
        periodsSec.put("H", Math.max(1L, 3600L / TIME_MULTIPLICATOR));
        periodsSec.put("D", Math.max(1L, 86400L / TIME_MULTIPLICATOR));
    }
}

