/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.charts;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.charts.Chart;
import org.vavilon.charts.model.Candle;
import org.vavilon.gdb.BigArray;
import org.vavilon.servers.model.Post;

public abstract class PostChart
extends Post {
    public List<CandleTick> newCandles = new ArrayList<CandleTick>();

    public PostChart track(String app, String key, double value) {
        this.newCandles.add(new CandleTick(app, key, value));
        return this;
    }

    public PostChart trackEvent(String app, String key, double value) {
        this.track(app, key, value);
        this.track(app, key, 0.0);
        return this;
    }

    public PostChart trackEvent(String app, String key) {
        this.trackEvent(app, key, 1.0);
        return this;
    }

    public PostChart trackEventTotalByPeriod(String app, String key, double value, String periodName) {
        Candle candle = Chart.getChartLastCandle(app, key, periodName);
        if (candle == null || candle.time != Chart.getPeriodTime(this.time(), periodName)) {
            this.trackEvent(app, key, value);
        } else {
            this.trackEvent(app, key, Chart.getChartLastValue(app, key, periodName) + value);
        }
        return this;
    }

    public PostChart trackEventTotalByPeriod(String app, String key, String periodName) {
        return this.trackEventTotalByPeriod(app, key, 1.0, periodName);
    }

    public PostChart trackTotal(String app, String key) {
        this.trackTotal(app, key, 1.0);
        return this;
    }

    public PostChart trackTotal(String app, String key, double value) {
        this.track(app, key, Chart.getChartLastValue(app, key) + value);
        return this;
    }

    @Override
    public void commit() {
        long timestamp = this.time();
        for (CandleTick tick : this.newCandles) {
            for (String periodName : Chart.periodsSec.keySet()) {
                long periodSec = Chart.periodsSec.get(periodName);
                long periodTime = timestamp / periodSec * periodSec;
                BigArray<Candle> chart = Chart.getChart(tick.app, tick.key, periodName);
                Candle lastCandle = null;
                if (chart.size() != 0L) {
                    lastCandle = chart.get(chart.size() - 1L);
                }
                if (lastCandle == null || periodTime != lastCandle.time) {
                    Candle candle = new Candle();
                    candle.period = periodName;
                    candle.time = periodTime;
                    candle.low = tick.value;
                    candle.high = tick.value;
                    candle.open = tick.value;
                    candle.close = tick.value;
                    chart.add(candle);
                    continue;
                }
                lastCandle.low = Math.min(lastCandle.low, tick.value);
                lastCandle.high = Math.max(lastCandle.high, tick.value);
                lastCandle.close = tick.value;
                chart.set(chart.size() - 1L, lastCandle);
            }
        }
    }

    class CandleTick {
        String app;
        String key;
        Double value;

        public CandleTick(String app, String key, Double value) {
            this.app = app;
            this.key = key;
            this.value = value;
        }
    }
}

