/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.servers;

import jakarta.servlet.Servlet;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.ee10.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.rewrite.handler.RedirectRegexRule;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.vavilon.servers.FtpServer;
import org.vavilon.servers.WssServer;
import org.vavilon.servers.handlers.ApiHandler;
import org.vavilon.servers.model.Endpoint;
import org.vavilon.servers.model.Subscription;
import org.vavilon.token.utils.Settings;

public abstract class HttpServer
implements ApiHandler.EndpointSever,
WssServer.Callback {
    private final Server server;
    public static final String APP = "https";
    private static final Integer HTTP_PORT = Settings.getInteger("http", "port", 80);
    private static final Integer PORT = Settings.getInteger("https", "port", 443);
    private static final String KEYSTORE_FILENAME = Settings.get("https", "keystore_filename");
    private static final String KEYSTORE_PASSWORD = Settings.get("https", "keystore_password");
    private static final String KEYSTORE_MANAGER_PASSWORD = Settings.get("https", "keystore_manager_password");

    @Override
    public abstract Endpoint getEndpoint(String var1);

    public HttpServer() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[0]);
        ContextHandler apiHandler = new ContextHandler("/");
        apiHandler.setHandler((Handler)new ApiHandler(this));
        contexts.addHandler((Handler)apiHandler);
        ContextHandler staticHandler = new ContextHandler("/");
        Path root = new File(".").toPath().toRealPath(new LinkOption[0]);
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setBaseResourceAsString(root.toString());
        staticHandler.setHandler((Handler)resourceHandler);
        staticHandler.insertHandler((Handler.Singleton)new Handler.Wrapper(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                response.getHeaders().add("Content-Security-Policy", "frame-src 'none'");
                response.getHeaders().add("X-Frame-Options", "DENY");
                response.getHeaders().add("X-Content-Type-Options", "nosniff");
                response.getHeaders().add("Referrer-Policy", "no-referrer-when-downgrade");
                return super.handle(request, response, callback);
            }
        });
        staticHandler.getMimeTypes().addMimeMapping("md", "text/markdown; charset=UTF-8");
        staticHandler.getMimeTypes().addMimeMapping("txt", "text/plain; charset=UTF-8");
        contexts.addHandler((Handler)staticHandler);
        ServletContextHandler wsHandler = new ServletContextHandler();
        wsHandler.addServlet(new ServletHolder((Servlet)new JettyWebSocketServlet(){

            protected void configure(JettyWebSocketServletFactory factory) {
                factory.setIdleTimeout(Duration.ofMinutes(5L));
                factory.addMapping("/", (req, res) -> new WssServer(HttpServer.this));
            }
        }), "/ws");
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)wsHandler, null);
        contexts.addHandler((Handler)wsHandler);
        this.server = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        http_config.setSecurePort(PORT.intValue());
        http_config.setSecureScheme(APP);
        int acceptorCount = 8;
        int selectorCount = -1;
        Duration idleTimeout = Duration.of(3L, ChronoUnit.MINUTES);
        ServerConnector http = new ServerConnector(this.server, null, null, null, acceptorCount, selectorCount, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        http.setPort(HTTP_PORT.intValue());
        http.setIdleTimeout(idleTimeout.toMillis());
        http.setAcceptQueueSize(8);
        GzipHandler gzip = new GzipHandler();
        gzip.setIncludedMimeTypes(new String[]{"text/html", "text/plain", "text/css", "application/javascript", "application/json", "image/svg+xml"});
        gzip.setHandler((Handler)contexts);
        RewriteHandler rewrite = new RewriteHandler();
        RedirectRegexRule wwwRule = new RedirectRegexRule();
        wwwRule.setRegex("http[s]?://www\\.(.*)");
        wwwRule.setLocation("https://$1");
        rewrite.addRule((Rule)wwwRule);
        rewrite.setHandler((Handler)gzip);
        File keystoreFile = new File(KEYSTORE_FILENAME);
        if (keystoreFile.exists()) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(keystoreFile.getAbsolutePath());
            sslContextFactory.setKeyStorePassword(KEYSTORE_PASSWORD);
            sslContextFactory.setKeyManagerPassword(KEYSTORE_MANAGER_PASSWORD);
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
            HttpConfiguration https_config = new HttpConfiguration(http_config);
            https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)});
            https.setPort(PORT.intValue());
            https.setIdleTimeout(idleTimeout.toMillis());
            https.setAcceptQueueSize(8);
            this.server.setConnectors(new Connector[]{http, https});
            SecuredRedirectHandler httpsRedirect = new SecuredRedirectHandler();
            httpsRedirect.setHandler((Handler)gzip);
            this.server.setHandler((Handler)httpsRedirect);
            System.out.println("HTTPS \u0432\u043a\u043b\u044e\u0447\u0435\u043d, \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442 \u0438 GZIP \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b");
        } else {
            this.server.setConnectors(new Connector[]{http});
            this.server.setHandler((Handler)gzip);
            System.out.println("keystore.jks \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, HTTPS \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d (\u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e HTTP)");
        }
    }

    public void start() throws Exception {
        new FtpServer().start();
        this.server.start();
    }

    @Override
    public void onMessage(Subscription sub) {
    }
}

