/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.servers.handlers;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.Callback;
import org.vavilon.servers.model.ContractException;
import org.vavilon.servers.model.Endpoint;
import org.vavilon.servers.model.Get;
import org.vavilon.token.Node;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class ApiHandler
extends AbstractHandler {
    public static final String DEFAULT_MODULE = Settings.get("https", "default_module");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final EndpointSever endpointSever;
    DefaultMustacheFactory factory = new DefaultMustacheFactory();

    public ApiHandler(EndpointSever endpointSever) {
        this.endpointSever = endpointSever;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Endpoint endpoint;
        String scriptPath = request.getHttpURI().getPath().substring(1);
        if (scriptPath.endsWith("/")) {
            scriptPath = scriptPath.substring(0, scriptPath.length() - 1);
        }
        if (Utils.isEmpty(scriptPath)) {
            scriptPath = DEFAULT_MODULE;
        }
        if ((endpoint = this.endpointSever.getEndpoint(scriptPath)) == null) {
            return false;
        }
        try {
            for (HttpField field : request.getHeaders()) {
                endpoint.headers.put(field.getName(), field.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        endpoint.meta.put("ip", Request.getRemoteAddr((Request)request));
        Map<String, Object> params = request.getMethod().equals("GET") ? Utils.toMap(org.vavilon.token.utils.Request.parseQuery(request.getHttpURI().getQuery())) : ApiHandler.parseBody(request);
        try {
            endpoint.run(scriptPath, params);
            if (request.getMethod().equals("GET")) {
                String mustacheFile;
                String ext = Utils.extractExtension(scriptPath);
                String string = mustacheFile = ext == null ? scriptPath + "/index.mustache" : scriptPath + ".mustache";
                if (Utils.fileExists(mustacheFile)) {
                    String localizedFile = Utils.getTranslationFilepath(mustacheFile, endpoint.getLanguage());
                    if (Utils.fileExists(localizedFile)) {
                        mustacheFile = localizedFile;
                    }
                    if (Node.isDebugMode) {
                        this.factory = new DefaultMustacheFactory();
                    }
                    Mustache template = this.factory.compile(mustacheFile);
                    StringWriter writer = new StringWriter();
                    String rendered = template.execute((Writer)writer, (Object)endpoint.responseObj).toString();
                    response.getHeaders().add("Content-Security-Policy", "frame-src 'none'");
                    response.getHeaders().add("X-Frame-Options", "DENY");
                    response.getHeaders().add(HttpHeader.CONTENT_TYPE, new MimeTypes().getMimeForExtension(ext == null ? "html" : ext) + ";charset=utf-8");
                    response.setStatus(200);
                    response.write(true, ByteBuffer.wrap(rendered.getBytes(StandardCharsets.UTF_8)), callback);
                    return true;
                }
            }
            if (endpoint.responseObj == null) {
                endpoint.responseObj = new Get.Response();
            }
            if (scriptPath.contains("hook")) {
                System.out.println(gson.toJson((Object)endpoint.responseObj));
            }
            response.getHeaders().put(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
            response.setStatus(200);
            response.write(true, ByteBuffer.wrap(gson.toJson((Object)endpoint.responseObj).getBytes(StandardCharsets.UTF_8)), callback);
        }
        catch (Exception e) {
            ApiHandler.catchError(e, request, response, callback);
        }
        return true;
    }

    public static void catchError(Exception e, Request request, Response response, Callback callback) {
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
        try {
            error.put("params", ApiHandler.parseBody(request));
            error.put("message", e.getMessage());
            if (e instanceof ContractException) {
                error.put("data", ((ContractException)e).data);
            }
            error.put("stack", Utils.getStackTrace(e));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String responseStr = gson.toJson(error);
        System.out.println("error: " + responseStr);
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
        response.setStatus(500);
        response.write(true, ByteBuffer.wrap(responseStr.getBytes(StandardCharsets.UTF_8)), callback);
    }

    public static Map<String, Object> parseBody(Request request) {
        try {
            return Utils.parseMap(Content.Source.asString((Content.Source)request, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Object>();
        }
    }

    public static interface EndpointSever {
        public Endpoint getEndpoint(String var1);
    }
}

