/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token;

import org.vavilon.app.deposit.Bitcoin;
import org.vavilon.app.deposit.Bnb;
import org.vavilon.app.deposit.Ethereum;
import org.vavilon.app.deposit.TronTrx;
import org.vavilon.app.deposit.TronUsdt;
import org.vavilon.token.base.AccountInfo;
import org.vavilon.token.base.Send;
import org.vavilon.token.contract.Mint;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class NodeInit {
    public static final String TG_USER_SEED = Settings.get("tokens", NodeInit.class.getSimpleName() + "_tg_user_seed");
    public static final String TG_USER_PASSWORD = Utils.hash(TG_USER_SEED);
    public static final String TG_USER_ADDRESS = Mint.hashAddress(TG_USER_PASSWORD);
    public static final String USER_SEED = Settings.get("tokens", NodeInit.class.getSimpleName() + "_user_seed");
    public static final String USER_PASSWORD = Utils.hash(USER_SEED);
    public static final String USER_ADDRESS = Mint.hashAddress(USER_PASSWORD);
    public static final String SEL_SEED = Settings.get("tokens", NodeInit.class.getSimpleName() + "_sel_seed");
    public static final String SEL_PASSWORD = Utils.hash(SEL_SEED);
    public static final String SEL_ADDRESS = Mint.hashAddress(SEL_PASSWORD);

    public String getPrevKey(String domain, String address) {
        return AccountInfo.request((String)domain, (String)address).account.prev_key;
    }

    public String tokenPass(String domain, String address, String password) {
        return Send.tokenPass(domain, address, password, this.getPrevKey(domain, address));
    }

    public static void regSimpleToken(String domain, Double supply, String user_seed) {
        String userPassword = Utils.hash(user_seed);
        String userAddress = Mint.hashAddress(userPassword);
        Send.regToken(domain, userAddress, userPassword, supply, null);
        Send.regAccount("usdt", userAddress, userPassword);
        Send.regAccount(domain, userAddress, userPassword);
    }

    public static void regContractToken(String domain, Double supply, String contract_seed, String delegate, String user_seed) {
        String contractPassword = Utils.hash(contract_seed);
        String contractAddress = Mint.hashAddress(contractPassword);
        Send.regToken(domain, contractAddress, contractPassword, supply, delegate);
        String userPassword = Utils.hash(user_seed);
        String userAddress = Mint.hashAddress(userPassword);
        Send.regAccount("usdt", userAddress, userPassword);
        Send.regAccount(domain, userAddress, userPassword);
    }

    NodeInit() {
        NodeInit.regContractToken("usdt", 1.0E8, TronUsdt.SEED, TronUsdt.CONTRACT, USER_SEED);
        NodeInit.regContractToken("bitcoin", 2.1E7, Bitcoin.SEED, Bitcoin.CONTRACT, USER_SEED);
        NodeInit.regContractToken("binancecoin", 1.4E8, Bnb.SEED, Bnb.CONTRACT, USER_SEED);
        NodeInit.regContractToken("ethereum", 1.2E8, Ethereum.SEED, Ethereum.CONTRACT, USER_SEED);
        NodeInit.regContractToken("tron", 1.0E11, TronTrx.SEED, TronTrx.CONTRACT, USER_SEED);
        NodeInit.regContractToken("vavilon", 10000.0, "card wing home athlete regular post notice paddle isolate zone payment chef", "mfm-contract/mint20", USER_SEED);
        NodeInit.regContractToken("selenium", 1000000.0, "card wing home athlete regular post notice paddle isolate zone payment chef", "mfm-contract/mint100", SEL_SEED);
        Send.request(TronUsdt.CONTRACT, "usdt", TronUsdt.ADDRESS, USER_ADDRESS, 10000.0, Send.tokenPass("usdt", TronUsdt.ADDRESS, TronUsdt.PASSWORD), null);
        Send.request("usdt", USER_ADDRESS, SEL_ADDRESS, 20.0, Send.tokenPass("usdt", USER_ADDRESS, USER_PASSWORD), null);
        Send.request(Bitcoin.CONTRACT, "bitcoin", Bitcoin.ADDRESS, USER_ADDRESS, 1.0, Send.tokenPass("bitcoin", Bitcoin.ADDRESS, Bitcoin.PASSWORD), null);
        Send.request(Ethereum.CONTRACT, "ethereum", Ethereum.ADDRESS, USER_ADDRESS, 1.0, Send.tokenPass("ethereum", Ethereum.ADDRESS, Ethereum.PASSWORD), null);
        Mint.regAccount("usdt", TG_USER_ADDRESS, TG_USER_PASSWORD);
        Mint.regAccount("vavilon", TG_USER_ADDRESS, TG_USER_PASSWORD);
        System.out.println("init finished");
    }
}

