/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.base;

import org.vavilon.app.airdrop.AirdropUtils;
import org.vavilon.app.airdrop.model.Airdrop;
import org.vavilon.app.exchange.bot.HedgeBot;
import org.vavilon.charts.Chart;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class TokenProfile
extends Get {
    public double getTotalWrapped() {
        double usd = 0.0;
        for (String domain : HedgeBot.wrappedDomains) {
            Token token = Send.getToken(domain);
            if (token == null) continue;
            Account supply = Send.getAccount(domain, token.address);
            usd += token.price * (token.supply - supply.balance);
        }
        Token gas_token = Send.getToken("usdt");
        Account supply = Send.getAccount("usdt", gas_token.address);
        return usd += gas_token.supply - supply.balance;
    }

    @Override
    public Get.Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddressNotRequired("address");
        Token token = Send.getToken(domain);
        if (token == null) {
            Utils.error("Token not found");
        }
        Response response = new Response();
        response.token = token;
        response.airdrop = AirdropUtils.airdropByDomain.get(domain);
        response.supply = Send.getAccount(domain, token.address);
        response.gas_account = Send.getAccount("usdt", address);
        if (address != null) {
            response.account = Send.getAccount(domain, address);
        }
        Analytics analytics = new Analytics();
        analytics.trans = Chart.getChartLastValue("tokens", domain + "_trans");
        analytics.trans7d = Chart.getChart7dTotal("tokens", domain + "_trans");
        analytics.accounts = Chart.getChartLastValue("tokens", domain + "_accounts");
        analytics.accounts7d = Chart.getChart7dTotal("tokens", domain + "_accounts");
        analytics.trans_count = Chart.getChartLastValue("tokens", "trans_count");
        analytics.tokens_count = Chart.getChartLastValue("tokens", "tokens_count");
        analytics.accounts_count = Chart.getChartLastValue("tokens", "accounts_count");
        analytics.accounts_count7d = Chart.getChart7dTotal("tokens", "accounts_count");
        analytics.trans_count7d = Chart.getChart7dTotal("tokens", "trans_count");
        analytics.tokens_count7d = Chart.getChart7dTotal("tokens", "tokens_count");
        analytics.total_wrapped = this.getTotalWrapped();
        response.analytics = analytics;
        return response;
    }

    public static Response request(String domain) {
        return TokenProfile.request(domain, null);
    }

    public static Response request(String domain, String address) {
        return (Response)new TokenProfile().run(null, Request.map("domain", domain, "address", address));
    }

    public class Response
    extends Get.Response {
        public Token token;
        public Account account;
        public Airdrop airdrop;
        public Account supply;
        public Account gas_account;
        public Analytics analytics;
    }

    public class Analytics {
        public double trans;
        public double trans7d;
        public double accounts;
        public double accounts7d;
        public double tokens_count;
        public double tokens_count7d;
        public double trans_count;
        public double trans_count7d;
        public double accounts_count;
        public double accounts_count7d;
        public double total_wrapped;
    }
}

