/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.base;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Transaction;
import org.vavilon.token.utils.Utils;

public class Transactions
extends Get {
    @Override
    public Get.Response get() {
        String address = this.getAddress("address");
        String domain = this.getString("domain");
        String to = this.getString("to");
        Long offset = this.getLong("offset");
        Long size = this.getLong("size", 20L);
        if (offset != null && offset < 0L) {
            Utils.error("offset less than zero");
        }
        if (size != null && size > 1000L) {
            Utils.error("size is too big");
        }
        List<Transaction> transactions = Send.getTrans(domain, address, to, offset, size);
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        for (Transaction transaction : transactions) {
            if (!(transaction.amount > 0.0)) continue;
            transaction.token = Send.getToken(transaction.domain);
            result.add(transaction);
        }
        Response response = new Response();
        response.trans = result;
        return response;
    }

    class Response
    extends Get.Response {
        List<Transaction> trans;

        Response() {
        }
    }
}

