/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.contract;

import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.contract.Contract;
import org.vavilon.token.contract.Mint;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class MiningInfo
extends Get {
    @Override
    public Get.Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddressNotRequired("address");
        Account bank = Send.getAccount(domain, Mint.MINING_ADDRESS);
        if (bank == null) {
            Utils.error("its not mining token");
        }
        Response response = new Response();
        response.bank = bank;
        response.last_hash = Contract.dataGet("mining/" + domain + "/last_hash");
        response.difficulty = Contract.dataGetLong("mining/" + domain + "/difficulty");
        response.gas_account = Send.getAccount("usdt", address);
        response.token_account = Send.getAccount(domain, address);
        return response;
    }

    public static Response request(String domain) {
        return MiningInfo.request(domain, null);
    }

    public static Response request(String domain, String address) {
        return (Response)new MiningInfo().run(null, Request.map("domain", domain, "address", address));
    }

    public class Response
    extends Get.Response {
        public String last_hash;
        public Long difficulty;
        public Account bank;
        public Account gas_account;
        public Account token_account;
    }
}

