/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app;

import java.time.Duration;
import org.vavilon.app.Deposit;
import org.vavilon.app.miner.AccountInfo;
import org.vavilon.app.miner.Miner;
import org.vavilon.app.miner.MinerSend;
import org.vavilon.app.miner.MinerUtils;
import org.vavilon.app.miner.ToggleDomain;
import org.vavilon.app.miner.Trans;
import org.vavilon.app.miner.Withdrawal;
import org.vavilon.app.miner.model.MinerAccount;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.app.telegram.utils.FormatFront;
import org.vavilon.servers.model.Endpoint;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.utils.InfiniteTimer;

public class MinerFarm
extends Deposit {
    public MinerFarm(String masterNode) throws Exception {
        super(masterNode);
        Send.regAccount("usdt", MinerUtils.MINER_ADDRESS, MinerUtils.MINER_PASSWORD);
        Send.regAccount("usdt", MinerUtils.ENERGY_ADDRESS, MinerUtils.ENERGY_PASSWORD);
        int i = 0;
        while ((long)i < MinerUtils.minerAccountsByAddress.values.size()) {
            MinerAccount minerAccount = (MinerAccount)MinerUtils.minerAccountsByAddress.values.get(i);
            Account minerAddressAccount = Send.getAccount("usdt", minerAccount.minerAddress);
            if (minerAddressAccount != null && minerAddressAccount.balance >= FormatFront.round(minerAccount.tariff * (double)minerAccount.getDomainList().length)) {
                Miner.activeMinerAccountsByUserAddress.put(minerAccount.userAddress, minerAccount);
            }
            ++i;
        }
        Send.depositListeners.add(tran -> {
            if (tran.to.equals(MinerUtils.MINER_ADDRESS) && tran.domain.equals("usdt")) {
                MinerSend.request(MinerUtils.MINER_ADDRESS, tran.from, tran.amount, Send.tokenPass("usdt", MinerUtils.MINER_ADDRESS, MinerUtils.MINER_PASSWORD));
            }
        });
    }

    @Override
    public void start() throws Exception {
        super.start();
        new InfiniteTimer(new Miner(), Duration.ofMinutes(1L)).start();
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-miner/account": {
                return new AccountInfo();
            }
            case "mfm-miner/send": {
                return new MinerSend();
            }
            case "mfm-miner/toggle_domain": {
                return new ToggleDomain();
            }
            case "mfm-miner/withdrawal": {
                return new Withdrawal();
            }
            case "mfm-miner/trans": {
                return new Trans();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        Send.loaderListeners.add(tran -> {
            TelegramUser user;
            if (tran.domain.equals("usdt") && MinerUtils.userAddressByMinerAddress.get(tran.to) != null && (user = TelegramUtils.getUserByAddress(MinerUtils.userAddressByMinerAddress.get(tran.to).toString())) != null) {
                user.total_buy_energy += tran.amount.doubleValue();
                ++user.buy_energy_count;
                TelegramUtils.usersByUserId.put("" + user.id, user);
            }
        });
    }
}

