/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.craft.model;

import java.util.HashMap;
import java.util.Map;
import org.vavilon.gdb.Top;
import org.vavilon.gdb.model.BigArrayCell;
import org.vavilon.gdb.utils.Bytes;
import org.vavilon.token.utils.Request;

public class Recipe
implements BigArrayCell,
Top.TopId {
    public String domain;
    public String prefix;
    public String recipe;
    public Map<String, Double> items = new HashMap<String, Double>();
    public Map<String, Double> balances = new HashMap<String, Double>();
    public long crafted;

    public Recipe() {
    }

    public Recipe(String recipe) {
        this.recipe = recipe;
    }

    @Override
    public void build(Bytes data) {
        data.addString64(this.recipe);
        data.addLong(this.crafted);
    }

    @Override
    public void parse(Bytes data) {
        this.recipe = data.readString64();
        this.crafted = data.readLong();
        Map<String, String> map = Request.parseQuery(this.recipe);
        for (String key : map.keySet()) {
            if (key.equals("domain")) {
                this.domain = map.get(key);
                this.prefix = this.domain.contains("_") ? this.domain.substring(0, this.domain.indexOf("_")) : null;
                continue;
            }
            this.items.put(key, Double.valueOf(map.get(key)));
        }
    }

    @Override
    public String getId() {
        return this.recipe;
    }
}

