/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import java.math.BigDecimal;
import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.String64;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.http.HttpService;

public class Bnb
implements InfiniteTimer.Callback {
    public static final String BINANCE_COIN = "binancecoin";
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", Bnb.class.getSimpleName() + "_deposit_address");
    public static final String NETWORK = "n";
    public static final String CONTRACT = "mfm/send?n=n&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", Bnb.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    public static final long BLOCK_GENERATE_SECONDS = 10L;
    public static final BigDecimal WEI_IN_BNB = BigDecimal.TEN.pow(18);
    public static final BigDecimal MIN_DEPOSIT_BNB = new BigDecimal("0.0001");
    private static final long LAST_SCANNED_HEIGHT = 63219198L;
    private final Web3j web3 = Web3j.build((Web3jService)new HttpService("https://bsc-dataseed.bnbchain.org"));
    private final BigArray<LongCell> bnbLastScannedHeight = new BigArray<LongCell>("deposit", "bnbLastScannedHeight", LongCell.class);

    @Override
    public void onTimer() throws Exception {
        long lastScannedHeight = this.bnbLastScannedHeight.size() > 0L ? this.bnbLastScannedHeight.get((long)(this.bnbLastScannedHeight.size() - 1L)).value : 63219198L;
        while (true) {
            EthBlock block = (EthBlock)this.web3.ethGetBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber(++lastScannedHeight), true).send();
            for (EthBlock.TransactionResult txResult : block.getBlock().getTransactions()) {
                BigDecimal valueBNB;
                Transaction tx = (Transaction)txResult.get();
                if (tx.getTo() == null || !tx.getTo().equalsIgnoreCase(DEPOSIT_ADDRESS) || (valueBNB = new BigDecimal(tx.getValue()).divide(WEI_IN_BNB)).compareTo(MIN_DEPOSIT_BNB) < 0) continue;
                Bnb.bnbTranSuccess(tx, valueBNB);
            }
            this.bnbLastScannedHeight.add(new LongCell(lastScannedHeight));
        }
    }

    public static void bnbTranSuccess(Transaction tx, BigDecimal valueBNB) {
        double toDeposit = Utils.roundDown(valueBNB.doubleValue());
        if (toDeposit == 0.0) {
            return;
        }
        String user_address = NodeInit.USER_ADDRESS;
        AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
        if (lock != null) {
            user_address = lock.user_address;
        }
        DepositUtils.tranIdToUserAddress.put(tx.getHash(), new String64(user_address));
        Send.request(CONTRACT, BINANCE_COIN, ADDRESS, user_address, toDeposit, Send.tokenPass(BINANCE_COIN, ADDRESS, PASSWORD), null);
    }
}

