/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import com.google.gson.Gson;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.String64;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class Ton
implements InfiniteTimer.Callback {
    public static final String NETWORK = "o";
    public static final String TON = "the-open-network";
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", Ton.class.getSimpleName() + "_deposit_address");
    public static final String CONTRACT = "mfm/send?n=o&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", Ton.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    public static final double NANOTON_IN_TON = 1.0E9;
    public static final double MIN_DEPOSIT_TON = 0.001;
    private static final long LAST_SCANNED_LT = 600000000000L;
    private static final Gson gson = new Gson();
    BigArray<LongCell> tonLastScannedLt = new BigArray<LongCell>("deposit", "tonLastScannedLt", LongCell.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public void onTimer() throws Exception {
        lastLt = this.tonLastScannedLt.size() > 0L ? this.tonLastScannedLt.get((long)(this.tonLastScannedLt.size() - 1L)).value : 600000000000L;
        block2: while (true) {
            try {
                json = Request.get("https://toncenter.com/api/v2/getTransactions?address=" + Ton.DEPOSIT_ADDRESS + "&limit=10&to_lt=" + lastLt + "&archival=true");
                response = (TonResponse)Ton.gson.fromJson(json, TonResponse.class);
            }
            catch (Exception e) {
                TimeUnit.SECONDS.sleep(3L);
                continue;
            }
            if (response == null || !response.ok || response.result == null || response.result.isEmpty()) {
                TimeUnit.SECONDS.sleep(5L);
                continue;
            }
            var4_3 = response.result.iterator();
            while (true) {
                if (var4_3.hasNext()) ** break;
                continue block2;
                tx = var4_3.next();
                if (tx.in_msg == null || tx.in_msg.source == null || (amountTon = tx.in_msg.value / 1.0E9) < 0.001) continue;
                txHash = tx.transaction_id != null && tx.transaction_id.hash != null ? tx.transaction_id.hash : String.valueOf(tx.transaction_id != null ? tx.transaction_id.lt : 0L);
                this.onTonDeposit(txHash, amountTon);
                if (tx.transaction_id == null) continue;
                this.tonLastScannedLt.add(new LongCell(tx.transaction_id.lt));
                lastLt = tx.transaction_id.lt;
            }
            break;
        }
    }

    private void onTonDeposit(String txHash, double amountTon) {
        try {
            String userAddress = NodeInit.USER_ADDRESS;
            AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
            if (lock != null) {
                userAddress = lock.user_address;
            }
            DepositUtils.tranIdToUserAddress.put(txHash, new String64(userAddress));
            Send.request(CONTRACT, TON, ADDRESS, userAddress, Utils.roundDown(amountTon), Send.tokenPass(TON, ADDRESS, PASSWORD), null);
        }
        catch (Exception e) {
            System.err.println("[TON Deposit Error] " + e.getMessage());
        }
    }

    public static class TonResponse {
        boolean ok;
        List<TonTransaction> result;
    }

    public static class TonTransaction {
        TonMessage in_msg;
        TonTxId transaction_id;
    }

    public static class TonMessage {
        String source;
        double value;
    }

    public static class TonTxId {
        long lt;
        String hash;
    }
}

