/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.events;

import java.util.LinkedHashMap;
import java.util.Map;
import org.vavilon.app.events.EventsUtils;
import org.vavilon.app.events.Recommendations;
import org.vavilon.app.telegram.Telegram;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.app.telegram.utils.Format;
import org.vavilon.token.Node;
import org.vavilon.token.NodeInit;

public class Track
extends EventsUtils {
    private static final Map<String, String> currentWindowBySession = new LinkedHashMap<String, String>(1000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 1000;
        }
    };

    @Override
    public void run() {
        String name = this.getRequired("name");
        String value = this.getString("value");
        String user_id = this.getString("user_id");
        String session = this.getString("session");
        if (name.equals("start")) {
            value = (String)this.meta.get("ip");
            TelegramUser user = TelegramUtils.getUserByAddress(user_id);
            if (user != null) {
                user.timezoneOffsetMinutes = this.getLong("timezone_offset_minutes", user.timezoneOffsetMinutes);
                user.language_code = this.getString("language_code", user.language_code);
                user.last_activity_date_sec = this.time();
                if (user.registration_date == 0L) {
                    user.registration_date = user.last_activity_date_sec;
                }
                TelegramUtils.usersByUserId.put("" + user.id, user);
            }
        }
        if (name.equals("openProfile")) {
            String fromWindow = currentWindowBySession.get(session);
            String toWindow = value;
            if (fromWindow != null && toWindow != null) {
                Recommendations.addTransition(fromWindow, toWindow);
            }
            currentWindowBySession.put(session, toWindow);
        }
        this.trackSessionEvent(name, value, user_id, session);
        if (Node.masterNode != null && !Node.isDebugMode) {
            Telegram.sendToAdmin(Format.formatAddressShort(user_id), name, value, "" + this.time(), name.equals("start") && !user_id.equals(NodeInit.USER_ADDRESS) && !user_id.equals(NodeInit.TG_USER_ADDRESS));
        }
    }
}

