/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange;

import java.util.List;
import org.vavilon.app.exchange.ExchangeUtils;
import org.vavilon.app.exchange.LiquidityBot;
import org.vavilon.app.exchange.Place;
import org.vavilon.app.exchange.model.Order;
import org.vavilon.servers.model.Get;

public class Orders
extends Get {
    @Override
    public Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddress("address");
        LiquidityBot bot = LiquidityBot.liquidityBots.computeIfAbsent(domain, d -> new LiquidityBot((String)d));
        bot.refresh();
        Response response = new Response();
        response.bot_address = bot.bot_address;
        response.active = Place.ordersActive(domain, address);
        response.history = ExchangeUtils.ordersHistory(domain, address, 0L, 10L);
        return response;
    }

    class Response
    extends Get.Response {
        public String bot_address;
        public List<Order> active;
        public List<Order> history;

        Response() {
        }
    }
}

