/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange.bot;

import org.vavilon.app.exchange.CancelAll;
import org.vavilon.app.exchange.LiquidityBot;
import org.vavilon.app.exchange.Place;
import org.vavilon.charts.Chart;
import org.vavilon.charts.model.Candle;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class CanalBot
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", CanalBot.class.getSimpleName() + "_seed");
    private final String bot_password;
    private final String bot_address;
    private final String domain;
    private final double VOLATILITY_THRESHOLD = 3.0;
    private final double ORDER_PERCENT = 0.02;
    private final double BUY_ADJUST = 0.99;
    private final double SELL_ADJUST = 1.01;

    public CanalBot(String domain) {
        this.domain = domain;
        this.bot_password = Utils.hash(SEED + " " + domain);
        this.bot_address = Send.hashAddress(this.bot_password);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        }
    }

    @Override
    public void onTimer() throws Exception {
        CancelAll.request(this.domain, this.bot_address);
        LiquidityBot liquidityBot = LiquidityBot.liquidityBots.get(this.domain);
        Candle candle = Chart.getChartLastCandle("exchange", this.domain + "_price", "D");
        double volatility = (candle.low - candle.high) / candle.low * 100.0;
        if (volatility <= 3.0) {
            double marketPrice = Place.getMarketPrice(this.domain);
            double botGasBalance = Send.getBalanceOrZero("usdt", this.bot_address);
            double botTokenBalance = Send.getBalanceOrZero(this.domain, this.bot_address);
            if (botGasBalance > 0.0) {
                double buyAmount = Utils.round(botGasBalance * 0.02);
                double buyPrice = Utils.round(marketPrice * 0.99);
                Place.buy(this.domain, buyPrice, buyAmount, this.bot_address);
                Send.request("usdt", this.bot_address, liquidityBot.bot_address, buyAmount, Send.tokenPass("usdt", this.bot_address, this.bot_password), null);
            }
            if (botTokenBalance > 0.0) {
                double sellAmount = Utils.round(botTokenBalance * 0.02);
                double sellPrice = Utils.round(marketPrice * 1.01);
                Place.sell(this.domain, sellPrice, sellAmount, this.bot_address);
                Send.request(this.domain, this.bot_address, liquidityBot.bot_address, sellAmount, Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
            }
        }
    }
}

