/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.miner;

import org.vavilon.app.miner.MinerUtils;
import org.vavilon.app.miner.model.MinerAccount;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class AccountInfo
extends Get {
    @Override
    public Get.Response get() {
        String address = this.getAddress("address");
        String domain = this.getString("domain");
        MinerAccount minerAccount = MinerUtils.minerAccountsByAddress.get(address);
        if (minerAccount == null) {
            Utils.error("account does not exist");
        }
        Token token = Send.getToken(minerAccount.minerAddress);
        Response response = new Response();
        response.miner_account = minerAccount;
        response.gas_account = Send.getAccount("usdt", minerAccount.minerAddress);
        if (domain != null) {
            response.token_account = Send.getAccount(domain, minerAccount.minerAddress);
        }
        response.token = token;
        return response;
    }

    public static Response request(String address) {
        return AccountInfo.request(address, null);
    }

    public static Response request(String address, String domain) {
        return (Response)new AccountInfo().run(null, Request.map("domain", domain, "address", address));
    }

    public class Response
    extends Get.Response {
        public MinerAccount miner_account;
        public Account gas_account;
        public Account token_account;
        public Token token;
    }
}

