/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.vavilon.gdb.BigFile;
import org.vavilon.gdb.model.BigArrayCell;
import org.vavilon.gdb.utils.Bytes;
import org.vavilon.token.utils.Utils;

public class BigArray<Type extends BigArrayCell> {
    public static final String DB = "db-";
    private final BigFile bigFile;
    public static final String SIZES_FILENAME = "sizes.ini";
    private final Class<Type> type;
    private final long cellSize;
    private final Map<Long, Type> cache;
    private final Deque<Long> recentRequests;
    private final Map<Long, Integer> requestCounts;
    private int maxQueueSize;
    private final int initialCacheSize;
    private long lastIntervalStart = System.currentTimeMillis();
    private int requestsThisInterval = 0;
    private double requestsPerInterval = 0.0;
    private final long INTERVAL_MS = 5000L;

    public BigArray(String app, String filename, Class<Type> type) {
        this(app, filename, type, Long.MAX_VALUE, 50);
    }

    public BigArray(String app, String filename, Class<Type> type, Long maxBlocks) {
        this(app, filename, type, maxBlocks, 50);
    }

    public BigArray(String app, String filename, Class<Type> type, Long maxBlocks, int initialCacheSize) {
        this.type = type;
        Bytes data = new Bytes();
        this.createValInstance().build(data);
        this.cellSize = data.size();
        if (this.cellSize == 0L) {
            throw new NullPointerException();
        }
        this.bigFile = this.initializeWithMigration(DB + app, filename, maxBlocks, this.cellSize);
        this.cache = new HashMap<Long, Type>();
        this.recentRequests = new ArrayDeque<Long>();
        this.requestCounts = new HashMap<Long, Integer>();
        this.initialCacheSize = initialCacheSize;
        this.maxQueueSize = initialCacheSize;
    }

    private BigFile initializeWithMigration(String app, String filename, Long maxBlocks, long newCellSize) {
        Map<String, String> sizes = Utils.readFileIni(SIZES_FILENAME);
        String sizeStr = sizes.get(this.getFileId(app, filename));
        if (sizeStr == null) {
            Utils.updateFileIni(SIZES_FILENAME, this.getFileId(app, filename), "" + newCellSize);
            return new BigFile(app, filename, maxBlocks);
        }
        try {
            Long previousSize = Long.parseLong(sizeStr);
            if (newCellSize > previousSize) {
                return this.migrateData(app, filename, maxBlocks, previousSize, newCellSize);
            }
            if (newCellSize < previousSize) {
                throw new RuntimeException("Cell size cannot be decreased. Previous: " + previousSize + ", current: " + newCellSize);
            }
            return new BigFile(app, filename, maxBlocks);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error during cell size migration check", e);
        }
    }

    private BigFile migrateData(String app, String filename, Long maxBlocks, long oldSize, long newSize) {
        BigFile oldFile = new BigFile(app, filename, maxBlocks);
        BigFile newFile = new BigFile(app, filename + "_migration_temp", maxBlocks);
        long sizeDifference = newSize - oldSize;
        byte[] padding = new byte[(int)sizeDifference];
        Arrays.fill(padding, (byte)0);
        long totalCells = oldFile.fileSize / oldSize;
        for (long i = 0L; i < totalCells; ++i) {
            byte[] oldData = oldFile.readBytes(i * oldSize, oldSize);
            if (oldData == null) continue;
            newFile.addBytes(com.google.common.primitives.Bytes.concat((byte[][])new byte[][]{oldData, padding}));
        }
        oldFile.removeFiles();
        newFile.renameFiles(filename);
        Utils.updateFileIni(SIZES_FILENAME, this.getFileId(app, filename), String.valueOf(newSize));
        System.out.println("Data migration completed successfully");
        return new BigFile(app, filename, maxBlocks);
    }

    private String getFileId(String app, String filename) {
        return app + "/" + filename;
    }

    public Type createValInstance() {
        try {
            return (Type)((BigArrayCell)this.type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type get(long index) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            this.recordAccess(index);
            BigArrayCell cached = (BigArrayCell)this.cache.get(index);
            if (cached != null) {
                return (Type)this.cloneCell(cached);
            }
            Type result = this.createValInstance();
            byte[] readiedData = this.bigFile.readBytes(index * this.cellSize, this.cellSize);
            if (readiedData != null) {
                result.parse(new Bytes(readiedData));
                this.cache.put(index, result);
                return this.cloneCell(result);
            }
        }
        return null;
    }

    private Type cloneCell(Type item) {
        Bytes data = new Bytes();
        item.build(data);
        byte[] bytes = data.getBytes();
        Type copy = this.createValInstance();
        copy.parse(new Bytes(bytes));
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long index, Type item) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            Bytes data = new Bytes();
            item.build(data);
            this.bigFile.writeBytes(index * this.cellSize, data.getBytes());
            this.cache.put(index, item);
            this.recordAccess(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(Type item) {
        BigArray bigArray = this;
        synchronized (bigArray) {
            Bytes data = new Bytes();
            item.build(data);
            long idx = this.bigFile.addBytes(data.getBytes()) / this.cellSize - 1L;
            this.cache.put(idx, item);
            this.recordAccess(idx);
            return idx;
        }
    }

    public long size() {
        return this.bigFile.fileSize / this.cellSize;
    }

    public long nextId() {
        return this.size();
    }

    private void recordAccess(long index) {
        ++this.requestsThisInterval;
        long now = System.currentTimeMillis();
        if (now - this.lastIntervalStart >= 5000L) {
            this.requestsPerInterval = this.requestsThisInterval;
            this.requestsThisInterval = 0;
            this.lastIntervalStart = now;
            if (this.requestsPerInterval > (double)this.maxQueueSize) {
                this.maxQueueSize = (int)(this.requestsPerInterval * 1.2);
            } else if (this.requestsPerInterval < (double)(this.maxQueueSize / 2) && this.maxQueueSize > this.initialCacheSize) {
                this.maxQueueSize = Math.max(this.initialCacheSize, this.maxQueueSize / 2);
            }
            this.enforceCacheLimit();
        }
        this.recentRequests.addLast(index);
        Integer count = this.requestCounts.get(index);
        this.requestCounts.put(index, count == null ? 1 : count + 1);
        this.enforceCacheLimit();
    }

    private void enforceCacheLimit() {
        while (this.recentRequests.size() > this.maxQueueSize) {
            long removed = this.recentRequests.removeFirst();
            Integer count = this.requestCounts.get(removed);
            if (count == null) continue;
            if (count <= 1) {
                this.requestCounts.remove(removed);
                this.cache.remove(removed);
                continue;
            }
            this.requestCounts.put(removed, count - 1);
        }
    }
}

