/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.vavilon.gdb.BigMap;
import org.vavilon.gdb.Top;

public class MultiTop<Type extends Top.TopId> {
    private final Map<String, Top<Type>> cache = new ConcurrentHashMap<String, Top<Type>>();
    private final Comparator<Type> comparator;
    private final int max;
    private final BigMap<Type> storage;
    private final String app;
    private final String dir;

    public MultiTop(String app, String dir, BigMap<Type> storage, Comparator<Type> comparator, int max) {
        this.app = app;
        this.dir = dir;
        this.storage = storage;
        this.comparator = comparator;
        this.max = max;
    }

    private Top<Type> getOrCreateTop(String id) {
        return this.cache.computeIfAbsent(id, id1 -> new Top<Type>(this.app + "/mtop3_" + this.dir, (String)id1, this.storage, this.comparator, this.max));
    }

    public void put(String id, Type item) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        this.getOrCreateTop(id).add(item);
    }

    public List<Type> getTop(String id) {
        return this.getOrCreateTop(id).getTop();
    }
}

