/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb;

import java.util.ArrayList;
import java.util.List;
import org.vavilon.gdb.BigMap;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.SearchItem;
import org.vavilon.gdb.model.SearchList;

public class SearchIndex {
    protected final BigMap<SearchList> tokensSearch;
    protected final BigMap<LongCell> valueToPriorities;

    public SearchIndex(String app, String filename) {
        this.tokensSearch = new BigMap<SearchList>(app, filename, SearchList.class);
        this.valueToPriorities = new BigMap<LongCell>(app, filename + ".priorities", LongCell.class);
    }

    public void put(String text, String value) {
        LongCell longCell = this.valueToPriorities.get(value);
        long weight = longCell == null ? 1L : longCell.toLong() + 1L;
        for (int i = 1; i < text.length(); ++i) {
            String substr = text.substring(0, i + 1);
            SearchList searchList = this.tokensSearch.get(substr);
            if (searchList == null) {
                searchList = new SearchList();
            }
            searchList.put(text, value, weight);
            this.tokensSearch.put(substr, searchList);
        }
        this.valueToPriorities.put(value, new LongCell(weight));
    }

    public List<String> get(String text) {
        ArrayList<String> response = new ArrayList<String>();
        SearchList searchList = this.tokensSearch.get(text);
        if (searchList != null) {
            for (SearchItem item : searchList.getList()) {
                response.add(item.value);
            }
        }
        return response;
    }
}

