/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gdb.utils;

import java.nio.ByteBuffer;

public class Bytes {
    private byte[] bytes;
    private int position;

    public Bytes() {
        this.bytes = new byte[0];
        this.position = 0;
    }

    public Bytes(byte[] bytes) {
        this.bytes = bytes;
        this.position = 0;
    }

    public byte[] read(int length) {
        byte[] result = new byte[length];
        System.arraycopy(this.bytes, this.position, result, 0, length);
        this.position += length;
        return result;
    }

    public int size() {
        return this.bytes.length;
    }

    private void addBytes(byte[] bytes) {
        this.bytes = com.google.common.primitives.Bytes.concat((byte[][])new byte[][]{this.bytes, bytes});
    }

    public static byte[] fromLong(Long value) {
        return ByteBuffer.allocate(8).putLong(value == null ? 0L : value).array();
    }

    public static long toLong(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    public static byte[] fromDouble(Double value) {
        return ByteBuffer.allocate(8).putDouble(value == null ? 0.0 : value).array();
    }

    public static Double toDouble(byte[] data) {
        return ByteBuffer.wrap(data).getDouble();
    }

    public static byte[] fromString(String string, int minSize) {
        if (string == null) {
            string = "";
        }
        byte[] bytes = new byte[minSize];
        byte[] stringBytes = string.getBytes();
        System.arraycopy(stringBytes, 0, bytes, 0, stringBytes.length);
        return bytes;
    }

    public static String toString(byte[] bytes) {
        return Bytes.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] data, int offset, int size) {
        int firstZeroIndex = size;
        for (int i = 0; i < size; ++i) {
            if (data[offset + i] != 0) continue;
            firstZeroIndex = i;
            break;
        }
        return firstZeroIndex == 0 ? null : new String(data, offset, firstZeroIndex);
    }

    public String readString8() {
        return Bytes.toString(this.read(8));
    }

    public String readString32() {
        return Bytes.toString(this.read(32));
    }

    public String readString64() {
        return Bytes.toString(this.read(64));
    }

    public String readString128() {
        return Bytes.toString(this.read(128));
    }

    public Double readDouble() {
        return Bytes.toDouble(this.read(8));
    }

    public Long readLong() {
        return Bytes.toLong(this.read(8));
    }

    public void addString8(String string) {
        this.addBytes(Bytes.fromString(string, 8));
    }

    public void addString32(String string) {
        this.addBytes(Bytes.fromString(string, 32));
    }

    public void addString64(String string) {
        this.addBytes(Bytes.fromString(string, 64));
    }

    public void addString128(String string) {
        this.addBytes(Bytes.fromString(string, 128));
    }

    public void addDouble(Double value) {
        this.addBytes(Bytes.fromDouble(value));
    }

    public void addLong(Long value) {
        this.addBytes(Bytes.fromLong(value));
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

