/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.gpt.junit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vavilon.gpt.Gpt;
import org.vavilon.token.utils.Utils;

public class TestRunner {
    public static final String SERVERS = "C:\\Users\\user\\Desktop\\servers";

    public static Map<String, String> getClassToErrorMap(String consoleOutput) {
        LinkedHashMap<String, List> errors = new LinkedHashMap<String, List>();
        Pattern pattern = Pattern.compile("JUnit [^:]+:(\\w+):(\\w+)\\(\\)\\n(?:.*?=> )(.+?)(?:\\n|$)", 32);
        Matcher matcher = pattern.matcher(consoleOutput);
        while (matcher.find()) {
            String className = matcher.group(1);
            String testName = matcher.group(2);
            String errorMsg = matcher.group(3).trim();
            errors.computeIfAbsent(className, k -> new ArrayList()).add(testName + " => " + errorMsg);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry entry : errors.entrySet()) {
            result.put((String)entry.getKey(), String.join((CharSequence)"\n", (Iterable)entry.getValue()));
        }
        return result;
    }

    public static void compile() throws IOException {
        List<String> cmd = Utils.list("javac", "-cp", "out/production/servers;lib/*;lib_dev/*", "-d", "out/production/servers");
        cmd.addAll(Utils.getFiles(SERVERS, "java"));
        Gpt.executeCommand(SERVERS, cmd);
    }

    public static void compileTests() throws IOException {
        File testDir = new File(SERVERS, "test");
        List<String> cmd = Utils.list("javac", "-cp", "out/production/servers;lib/*;lib_dev/*", "-d", "out/test/servers");
        cmd.addAll(Utils.getFiles(testDir.getAbsolutePath(), "java"));
        Gpt.executeCommand(SERVERS, cmd);
    }

    public static Map<String, String> getErrors(String packageName) throws IOException {
        if (packageName == null || packageName.isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        TestRunner.compile();
        TestRunner.compileTests();
        String consoleOutput = Gpt.executeCommand(SERVERS, Utils.list("java", "-cp", "out/test/servers;out/production/servers;lib/*;lib_dev/*", "org.junit.platform.console.ConsoleLauncher", "execute", "--select-package", packageName));
        return TestRunner.getClassToErrorMap(consoleOutput);
    }

    public static Map<String, String> getMapClassToError(String className) throws IOException {
        TestRunner.compile();
        TestRunner.compileTests();
        String consoleOutput = Gpt.executeCommand(SERVERS, Utils.list("java", "-cp", "out/test/servers;out/production/servers;lib/*;lib_dev/*", "org.junit.platform.console.ConsoleLauncher", "execute", "--select-class", className + "Test"));
        return TestRunner.getClassToErrorMap(consoleOutput);
    }

    public static void main(String[] args) throws IOException {
        System.out.println(TestRunner.getMapClassToError("com.metabrain.gdb.BigArray"));
    }
}

