/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.servers.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public abstract class Endpoint
implements Runnable {
    public String scriptPath;
    public Map<String, String> params = new HashMap<String, String>();
    public Map<String, String> headers = new HashMap<String, String>();
    public Map<String, String> meta = new HashMap<String, String>();
    public Map<String, Object> body = new HashMap<String, Object>();
    public Get.Response responseObj = null;

    public Get.Response run(String scriptPath, Map<String, Object> body) {
        this.scriptPath = scriptPath;
        this.params = Request.parseQuery(scriptPath);
        this.body = body;
        return null;
    }

    private Object getParam(String key) {
        Object value = this.params.get(key);
        if (value == null) {
            value = this.body.get(key);
        }
        return value;
    }

    protected String getString(String key, String defaultValue) {
        Object value = this.getParam(key);
        if (value == null || !(value instanceof String)) {
            return defaultValue;
        }
        return (String)value;
    }

    protected String getString(String key) {
        return this.getString(key, null);
    }

    protected String getRequired(String key) {
        String value = this.getString(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected String getAddressNotRequired(String key) {
        String value = this.getString(key);
        if (value != null && value.length() == 64) {
            value = Send.address(value);
        }
        return value;
    }

    protected String getAddress(String key) {
        String value = this.getRequired(key);
        if (value.length() == 64) {
            value = Send.address(value);
        }
        return value;
    }

    protected Long getLong(String key, Long defaultValue) {
        Object value = this.getParam(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Double) {
            return (long)((Double)value).doubleValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        return defaultValue;
    }

    protected Long getLong(String key) {
        return this.getLong(key, null);
    }

    protected Long getLongRequired(String key) {
        Long value = this.getLong(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected Double getDouble(String key, Double defaultValue) {
        Object value = this.getParam(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return defaultValue;
    }

    protected Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    protected Double getDoubleRequired(String key) {
        Double value = this.getDouble(key);
        if (value == null) {
            this.errorEmpty(key);
        }
        return value;
    }

    protected BigDecimal getDecimalRequired(String key) {
        return BigDecimal.valueOf(this.getDoubleRequired(key));
    }

    private void errorEmpty(String key) {
        Utils.error(key + " is empty");
    }

    public String getLanguage() {
        String lang = this.getString("lang");
        if (lang == null) {
            lang = this.getString("Accept-Language");
        }
        if (lang != null) {
            return lang.split(",")[0].split(";")[0].trim();
        }
        return "en";
    }
}

