/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.token.base.model;

import org.vavilon.app.miner.Miner;
import org.vavilon.app.telegram.utils.Format;
import org.vavilon.gdb.Top;
import org.vavilon.gdb.model.BigArrayCell;
import org.vavilon.gdb.utils.Bytes;
import org.vavilon.token.utils.Request;

public class Token
implements BigArrayCell,
Top.TopId {
    public String domain;
    public String address;
    public String delegate;
    public Double supply;
    public Double price = 0.0;
    public Double price24 = 0.0;
    public Double volume24 = 0.0;
    public Long difficulty = 0L;
    public Double difficulty24 = 0.0;
    public Double locked_supply;
    public Double mint_reward;
    public Long created = 0L;

    @Override
    public String getId() {
        return this.domain;
    }

    public Token() {
    }

    public Token(String domain, Double supply, String delegate, String address) {
        this.domain = domain;
        this.supply = supply;
        this.delegate = delegate;
        this.address = address;
    }

    public Token clone() {
        Token token = new Token();
        token.domain = this.domain;
        token.address = this.address;
        token.delegate = this.delegate;
        token.supply = this.supply;
        token.price = this.price;
        token.price24 = this.price24;
        token.volume24 = this.volume24;
        token.difficulty = this.difficulty;
        token.difficulty24 = this.difficulty24;
        token.locked_supply = this.locked_supply;
        token.mint_reward = this.mint_reward;
        token.created = this.created;
        return token;
    }

    @Override
    public void build(Bytes data) {
        data.addString64(this.domain);
        data.addString32(this.address);
        data.addString64(this.delegate);
        data.addDouble(this.supply);
        data.addDouble(this.price);
        data.addDouble(this.price24);
        data.addDouble(this.volume24);
        data.addLong(this.difficulty);
        data.addDouble(this.difficulty24);
        data.addDouble(this.locked_supply);
        data.addDouble(this.mint_reward);
        data.addLong(this.created);
    }

    @Override
    public void parse(Bytes data) {
        this.domain = data.readString64();
        this.address = data.readString32();
        this.delegate = data.readString64();
        this.supply = data.readDouble();
        this.price = data.readDouble();
        this.price24 = data.readDouble();
        this.volume24 = data.readDouble();
        this.difficulty = data.readLong();
        this.difficulty24 = data.readDouble();
        this.locked_supply = data.readDouble();
        this.mint_reward = data.readDouble();
        this.created = data.readLong();
    }

    public boolean isWrapped() {
        return Request.parseQuery(this.delegate).containsKey("a");
    }

    public boolean getIsWrappedToken() {
        return this.delegate != null && this.delegate.startsWith("mfm/send") && this.delegate.contains("&a=");
    }

    public boolean getIsMiningToken() {
        return this.delegate != null && this.delegate.startsWith("mfm-contract/mint");
    }

    public boolean getIsCraftToken() {
        return this.delegate != null && this.delegate.startsWith("mfm-contract/craft");
    }

    public boolean getIsSimpleToken() {
        return this.delegate != null && this.delegate.isEmpty();
    }

    public String getFormattedDomain() {
        return Format.formatDomain(this.domain);
    }

    public String getFormattedPrice() {
        return Format.formatPrice(this.price);
    }

    public String getFormattedPrice24() {
        return Format.formatChange(this.price24);
    }

    public String getFormattedDifficulty() {
        return Format.formatDifficulty(this.difficulty.longValue());
    }

    public String getFormattedDifficulty24() {
        return Format.formatChange(this.difficulty24);
    }

    public String getCapitalization() {
        return Format.formatPrice(this.price * this.supply);
    }

    public double getCostPrice() {
        return (double)this.difficulty.longValue() * Miner.minerFor100kHashes / 100000.0 + Miner.gasForOneMinting;
    }
}

