/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app;

import java.time.Duration;
import org.vavilon.app.Analytics;
import org.vavilon.app.deposit.Bitcoin;
import org.vavilon.app.deposit.Bnb;
import org.vavilon.app.deposit.DepositAddressLock;
import org.vavilon.app.deposit.Ethereum;
import org.vavilon.app.deposit.Lock;
import org.vavilon.app.deposit.TronTrx;
import org.vavilon.app.deposit.TronUsdt;
import org.vavilon.app.exchange.bot.HedgeBot;
import org.vavilon.servers.model.Endpoint;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Utils;

public class Deposit
extends Analytics {
    public static final InfiniteTimer tronUsdtChecker;
    public static final InfiniteTimer tronTrxChecker;
    public static final InfiniteTimer bitcoinChecker;
    public static final InfiniteTimer etheriumChecker;
    public static final InfiniteTimer bnbChecker;

    public Deposit(String masterNode) throws Exception {
        super(masterNode);
    }

    @Override
    public void start() throws Exception {
        super.start();
        HedgeBot.hedgeTokens.add("bitcoin");
        HedgeBot.hedgeTokens.add("ethereum");
        HedgeBot.hedgeTokens.add("tron");
        HedgeBot.hedgeTokens.add("binancecoin");
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-deposit/deposit_address_block": {
                return new DepositAddressLock();
            }
            case "mfm-deposit/lock": {
                return new Lock();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        if (isDebugMode) {
            Utils.deleteDirRecursively("db-deposit");
        }
        tronUsdtChecker = new InfiniteTimer(new TronUsdt(), Duration.ofSeconds(10L), Duration.ofMinutes(30L));
        tronTrxChecker = new InfiniteTimer(new TronTrx(), Duration.ofSeconds(10L), Duration.ofMinutes(30L));
        bitcoinChecker = new InfiniteTimer(new Bitcoin(), Duration.ofMinutes(1L), Duration.ofMinutes(30L));
        etheriumChecker = new InfiniteTimer(new Ethereum(), Duration.ofSeconds(12L), Duration.ofMinutes(30L));
        bnbChecker = new InfiniteTimer(new Bnb(), Duration.ofSeconds(10L), Duration.ofMinutes(30L));
    }
}

