/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app;

import java.time.Duration;
import java.util.List;
import java.util.Scanner;
import org.vavilon.app.Docs;
import org.vavilon.app.exchange.Cancel;
import org.vavilon.app.exchange.CancelAll;
import org.vavilon.app.exchange.LiquidityAdd;
import org.vavilon.app.exchange.LiquidityBot;
import org.vavilon.app.exchange.OrderBook;
import org.vavilon.app.exchange.Orders;
import org.vavilon.app.exchange.Place;
import org.vavilon.app.exchange.bot.CanalBot;
import org.vavilon.app.exchange.bot.HedgeBot;
import org.vavilon.app.exchange.bot.LiquidityPump;
import org.vavilon.app.exchange.bot.MinerBot;
import org.vavilon.app.exchange.bot.PricePump;
import org.vavilon.app.exchange.bot.SelfCostBot;
import org.vavilon.app.exchange.model.Order;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.servers.model.Endpoint;
import org.vavilon.servers.model.Subscription;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.contract.Contract;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Utils;

public class Exchange
extends Docs {
    public static void main(String[] args) throws Exception {
        String masterNode = null;
        if (args.length >= 1) {
            masterNode = args[0];
        }
        new Exchange(masterNode).start();
        new Scanner(System.in).hasNext();
    }

    public Exchange(String masterNode) throws Exception {
        super(masterNode);
        Contract.depositListeners.add(tran -> {
            List waitOrderList = (List)Place.waitOrders.get(tran.from);
            if (waitOrderList != null) {
                for (Order order : waitOrderList) {
                    TelegramUser user;
                    if ((order.is_sell != 1L || !order.domain.equals(tran.domain) || order.amount != tran.amount) && (order.is_sell != 0L || !tran.domain.equals("usdt") || order.total != tran.amount)) continue;
                    Place.incBalance(tran.domain, tran.from, tran.amount);
                    new Place().run("", Utils.toMap(order));
                    waitOrderList.remove(order);
                    if (tran.domain.equals("usdt") && (user = TelegramUtils.getUserByAddress(tran.from)) != null) {
                        user.total_buy_exchange += tran.amount.doubleValue();
                        ++user.buy_exchange_count;
                        TelegramUtils.usersByUserId.put("" + user.id, user);
                    }
                    break;
                }
            } else if (LiquidityBot.isLiquidityBotAddress(tran.domain, tran.to)) {
                Place.incBalance(tran.domain, tran.to, tran.amount);
            }
        });
    }

    @Override
    public void start() throws Exception {
        super.start();
        int i = 1;
        while ((long)i < Contract.tokensByDomain.values.size()) {
            Token token = (Token)Contract.tokensByDomain.values.get(i);
            if (!token.domain.equals("usdt")) {
                LiquidityBot.liquidityBots.computeIfAbsent(token.domain, domain2 -> new LiquidityBot((String)domain2)).refresh();
                PricePump.bots.computeIfAbsent(token.domain, domain2 -> new PricePump((String)domain2)).refresh();
            }
            ++i;
        }
        if (!isDebugMode) {
            new InfiniteTimer(new HedgeBot(), Duration.ofMinutes(1L)).start();
        }
        new InfiniteTimer(new CanalBot("vavilon"), Duration.ofHours(1L)).start();
        new InfiniteTimer(new SelfCostBot("vavilon"), Duration.ofHours(1L)).start();
        new InfiniteTimer(new LiquidityPump("vavilon", 10.0), Duration.ofDays(1L)).start();
        new InfiniteTimer(new MinerBot("vavilon"), Duration.ofMinutes(1L)).start();
        if (isDebugMode) {
            LiquidityBot liquidityBot = LiquidityBot.liquidityBots.get("vavilon");
            Send.request("vavilon", NodeInit.USER_ADDRESS, liquidityBot.bot_address, 0.001, Send.tokenPass("vavilon", NodeInit.USER_ADDRESS, NodeInit.USER_PASSWORD), null);
            Send.request("usdt", NodeInit.USER_ADDRESS, liquidityBot.bot_address, 0.5, Send.tokenPass("usdt", NodeInit.USER_ADDRESS, NodeInit.USER_PASSWORD), null);
            Send.request("vavilon", NodeInit.USER_ADDRESS, NodeInit.TG_USER_ADDRESS, 1.0E-4, Send.tokenPass("vavilon", NodeInit.USER_ADDRESS, NodeInit.USER_PASSWORD), null);
            SelfCostBot selfCostBot = new SelfCostBot("vavilon");
            Send.request("usdt", NodeInit.USER_ADDRESS, selfCostBot.bot_address, 1.0, Send.tokenPass("usdt", NodeInit.USER_ADDRESS, NodeInit.USER_PASSWORD), null);
            selfCostBot.onTimer();
        }
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-exchange/place": {
                return new Place();
            }
            case "mfm-exchange/cancel": {
                return new Cancel();
            }
            case "mfm-exchange/orderbook": {
                return new OrderBook();
            }
            case "mfm-exchange/user_orders": {
                return new Orders();
            }
            case "mfm-exchange/cancel_all": {
                return new CancelAll();
            }
            case "mfm-exchange/liquidity_add": {
                return new LiquidityAdd();
            }
        }
        return super.getEndpoint(uri);
    }

    @Override
    public void onMessage(Subscription sub) {
        super.onMessage(sub);
        String[] topic = sub.subscribe.split(":");
        if (topic[0].equals("orderbook")) {
            LiquidityBot.liquidityBots.computeIfAbsent(topic[1], domain2 -> new LiquidityBot((String)domain2)).refresh();
        }
    }
}

