/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app;

import java.time.Duration;
import org.vavilon.app.Airdrops;
import org.vavilon.app.deposit.TronUsdt;
import org.vavilon.app.telegram.Hook;
import org.vavilon.app.telegram.Login;
import org.vavilon.app.telegram.Messages;
import org.vavilon.app.telegram.SubscriptionCheck;
import org.vavilon.app.telegram.Telegram;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.app.telegram.utils.Format;
import org.vavilon.servers.model.Endpoint;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;

public class TelegramBot
extends Airdrops {
    public TelegramBot(String masterNode) throws Exception {
        super(masterNode);
        Send.depositListeners.add(tran -> {
            if (tran.amount > 0.0) {
                Telegram.sendToAddress(tran.to, "you_have_received", Request.map("amount", Format.formatAmount(tran.amount, tran.domain), "from", Format.formatAddress(tran.from), "txid", Format.formatHashShort(tran.next_hash)));
            }
        });
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (!isDebugMode) {
            new InfiniteTimer(new Messages(), Duration.ofMinutes(1L)).runOnceAndStart();
        }
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        switch (uri) {
            case "mfm-telegram/hook": {
                return new Hook();
            }
            case "mfm-telegram/login": {
                return new Login();
            }
            case "mfm-telegram/subscription_check": {
                return new SubscriptionCheck();
            }
        }
        return super.getEndpoint(uri);
    }

    static {
        TelegramUser user;
        int i;
        if (TelegramBot.isNeedRecalc()) {
            i = 1;
            while ((long)i < TelegramUtils.usersByUserId.values.size()) {
                user = (TelegramUser)TelegramUtils.usersByUserId.values.get(i);
                System.out.println(Request.gson.toJson((Object)user));
                user.clearOnchainStatistic();
                TelegramUtils.usersByUserId.put("" + user.id, user);
                ++i;
            }
        }
        i = 1;
        while ((long)i < TelegramUtils.usersByUserId.values.size()) {
            user = (TelegramUser)TelegramUtils.usersByUserId.values.get(i);
            user = TelegramUtils.getUserByUserId(user.id);
            System.out.println(Request.gson.toJson((Object)user));
            ++i;
        }
        Send.loaderListeners.add(tran -> {
            TelegramUser user;
            if (tran.from.equals(TronUsdt.ADDRESS) && (user = TelegramUtils.getUserByAddress(tran.to)) != null) {
                user.total_deposited += tran.amount.doubleValue();
                ++user.deposit_count;
                TelegramUtils.usersByUserId.put("" + user.id, user);
            }
        });
    }
}

