/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.craft;

import java.util.List;
import org.vavilon.app.craft.CraftUtils;
import org.vavilon.app.craft.model.Recipe;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.Utils;

public class RecipeInfo
extends Get {
    @Override
    public Response get() {
        String contractAddress;
        Recipe recipe;
        String domain = this.getRequired("domain");
        String address = this.getAddressNotRequired("address");
        List<String> addresses = CraftUtils.recipesSearch.get(domain);
        if (addresses == null || addresses.isEmpty()) {
            Utils.error("No recipe found for domain: " + domain);
        }
        if ((recipe = CraftUtils.recipesByAddress.get(contractAddress = addresses.get(0))) == null) {
            Utils.error("Recipe not found for address: " + contractAddress);
        }
        for (String itemDomain : recipe.items.keySet()) {
            recipe.balances.put(itemDomain, Send.getBalanceOrZero(itemDomain, address));
        }
        Response response = new Response();
        response.recipe = recipe;
        return response;
    }

    class Response
    extends Get.Response {
        Recipe recipe;

        Response() {
        }
    }
}

