/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import org.bitcoinj.core.Address;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.params.MainNetParams;
import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.String64;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class Bitcoin
implements InfiniteTimer.Callback {
    public static final String BITCOIN = "bitcoin";
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", Bitcoin.class.getSimpleName() + "_deposit_address");
    public static final String NETWORK = "b";
    public static String CONTRACT = "mfm-token/send?n=b&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", Bitcoin.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    public static final long BLOCK_GENERATE_MINUTES = 1L;
    public static double SATOSHI_IN_BITCOIN = 1.0E8;
    public static double MIN_DEPOSIT_SATOSHI = SATOSHI_IN_BITCOIN / 10000.0;
    NetworkParameters mainnet = MainNetParams.get();
    private static long LAST_SCANNED_HEIGHT = 913908L;
    BigArray<LongCell> bitcoinLastScannedHeight = new BigArray<LongCell>("deposit", "bitcoinLastScannedHeight", LongCell.class);

    @Override
    public void onTimer() throws Exception {
        Context context = new Context(this.mainnet);
        Context.propagate((Context)context);
        long lastScannedHeight = this.bitcoinLastScannedHeight.size() > 0L ? this.bitcoinLastScannedHeight.get((long)(this.bitcoinLastScannedHeight.size() - 1L)).value : LAST_SCANNED_HEIGHT;
        while (true) {
            String blockHash = Request.get("https://blockstream.info/api/block-height/" + ++lastScannedHeight);
            byte[] rawBlock = Request.getBytes("https://blockstream.info/api/block/" + blockHash + "/raw");
            Block block = new Block(this.mainnet, rawBlock);
            for (Transaction transaction : block.getTransactions()) {
                for (TransactionOutput output : transaction.getOutputs()) {
                    long satoshi = output.getValue().getValue();
                    if (!((double)satoshi >= MIN_DEPOSIT_SATOSHI)) continue;
                    String addressStr = null;
                    try {
                        Address address = output.getScriptPubKey().getToAddress(this.mainnet, true);
                        addressStr = address.toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!DEPOSIT_ADDRESS.equals(addressStr)) continue;
                    Bitcoin.bitcoinTranSuccess(output, transaction);
                }
            }
            this.bitcoinLastScannedHeight.add(new LongCell(lastScannedHeight));
        }
    }

    public static void bitcoinTranSuccess(TransactionOutput output, Transaction tran) {
        long satoshi = output.getValue().getValue();
        double toDeposit = Utils.roundDown((double)satoshi / SATOSHI_IN_BITCOIN);
        if (toDeposit == 0.0) {
            return;
        }
        String user_address = NodeInit.USER_ADDRESS;
        AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
        if (lock != null) {
            user_address = lock.user_address;
        }
        DepositUtils.tranIdToUserAddress.put(tran.getTxId().toString(), new String64(user_address));
        Send.request(CONTRACT, BITCOIN, ADDRESS, user_address, Utils.roundDown(toDeposit), Send.tokenPass(BITCOIN, ADDRESS, PASSWORD), null);
    }
}

