/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import java.time.Duration;
import java.util.Map;
import org.vavilon.app.Deposit;
import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class DepositAddressLock
extends Get {
    @Override
    public Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddress("address");
        Token token = Send.getToken(domain);
        Map<String, String> params = Request.parseQuery(token.delegate);
        String deposit_address = params.get("a");
        AddressLock lock = DepositUtils.locksByDepositAddress.get(deposit_address);
        if (lock == null || lock.deadline < this.currentTimeSec()) {
            long deadlineTimeSec = this.currentTimeSec() + Duration.ofMinutes(30L).getSeconds();
            lock = new AddressLock(deposit_address, address, deadlineTimeSec);
            DepositUtils.locksByDepositAddress.put(deposit_address, lock);
            String network = params.get("n");
            if (network.equals("t")) {
                Deposit.tronUsdtChecker.restart();
            }
            if (network.equals("trx")) {
                Deposit.tronTrxChecker.restart();
            }
            if (network.equals("b")) {
                Deposit.bitcoinChecker.restart();
            }
            if (network.equals("e")) {
                Deposit.etheriumChecker.restart();
            }
            if (network.equals("n")) {
                Deposit.bnbChecker.restart();
            }
        }
        if (!lock.user_address.equals(address)) {
            Utils.error("address is busy");
        }
        Response response = new Response();
        response.lock = lock;
        return response;
    }

    private long currentTimeSec() {
        return System.currentTimeMillis() / 1000L;
    }

    class Response
    extends Get.Response {
        AddressLock lock;

        Response() {
        }
    }
}

