/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.deposit;

import org.vavilon.app.deposit.DepositUtils;
import org.vavilon.app.deposit.model.AddressLock;
import org.vavilon.gdb.BigArray;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.gdb.model.String64;
import org.vavilon.token.NodeInit;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.http.HttpService;

public class Ethereum
implements InfiniteTimer.Callback {
    public static final String NETWORK = "e";
    public static final String ETHEREUM = "ethereum";
    private static final String DEPOSIT_ADDRESS = Settings.get("deposit", Ethereum.class.getSimpleName() + "_deposit_address");
    public static final String CONTRACT = "mfm-token/send?n=e&a=" + DEPOSIT_ADDRESS;
    public static final String SEED = Settings.get("deposit", Ethereum.class.getSimpleName() + "_seed");
    public static final String PASSWORD = Utils.hash(SEED);
    public static final String ADDRESS = Send.hashAddress(PASSWORD);
    private static long LAST_SCANNED_HEIGHT = 23384082L;
    public static double GWEI_IN_ETHERIUM = 1.0E18;
    public static double MIN_DEPOSIT_ETHER = 1.0E-4;
    public static final long BLOCK_GENERATE_SECONDS = 12L;
    Web3j web3j = Web3j.build((Web3jService)new HttpService("https://ethereum-rpc.publicnode.com"));
    BigArray<LongCell> ethereumLastScannedHeight = new BigArray<LongCell>("deposit", "ethereumLastScannedHeight", LongCell.class);

    @Override
    public void onTimer() throws Exception {
        long lastScannedHeight = this.ethereumLastScannedHeight.size() > 0L ? this.ethereumLastScannedHeight.get((long)(this.ethereumLastScannedHeight.size() - 1L)).value : LAST_SCANNED_HEIGHT;
        while (true) {
            EthBlock block = (EthBlock)this.web3j.ethGetBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber(lastScannedHeight), true).send();
            for (EthBlock.TransactionResult txResult : block.getBlock().getTransactions()) {
                double amountEther;
                EthBlock.TransactionObject tx = (EthBlock.TransactionObject)txResult.get();
                if (!DEPOSIT_ADDRESS.equalsIgnoreCase(tx.getTo()) || !((amountEther = tx.getValue().doubleValue() / GWEI_IN_ETHERIUM) >= MIN_DEPOSIT_ETHER)) continue;
                String userAddress = NodeInit.USER_ADDRESS;
                AddressLock lock = DepositUtils.locksByDepositAddress.get(DEPOSIT_ADDRESS);
                if (lock != null) {
                    userAddress = lock.user_address;
                }
                double depositAmount = Utils.roundDown(amountEther);
                DepositUtils.tranIdToUserAddress.put(tx.getHash(), new String64(userAddress));
                Send.request(CONTRACT, ETHEREUM, ADDRESS, userAddress, depositAmount, Send.tokenPass(ETHEREUM, ADDRESS, PASSWORD), null);
            }
            this.ethereumLastScannedHeight.add(new LongCell(lastScannedHeight));
            ++lastScannedHeight;
        }
    }
}

