/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.docs;

import java.util.List;
import java.util.Map;
import org.vavilon.app.docs.DocsUtils;
import org.vavilon.app.docs.model.Proposal;
import org.vavilon.servers.model.Get;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class Docs
extends Get {
    public static final Map<String, String> prismMap = Utils.toStringMap(Request.map("js", "javascript", "ts", "typescript", "py", "python", "java", "java", "c", "c", "cpp", "cpp", "html", "markup", "htm", "markup", "md", "markdown", "json", "json", "css", "css"));

    @Override
    public Get.Response get() {
        String doc = this.getRequired("doc");
        Long offset = this.getLong("offset", 0L);
        Long size = this.getLong("size", 10L);
        String originalFile = "mfm-landing/docs/" + doc;
        String originalData = Utils.readFile(originalFile);
        String originalHash = Utils.hash(originalData);
        List<Proposal> proposals = DocsUtils.getProposals(originalFile, offset, size);
        for (Proposal proposal : proposals) {
            proposal.proposalData = Utils.readFile(proposal.getProposalFile());
            proposal.outdated = !originalHash.equals(proposal.originalHash);
        }
        String prismLang = prismMap.getOrDefault(Utils.extractExtension(originalFile), "markup");
        Response response = new Response();
        response.prismLang = prismLang;
        response.originalData = originalData;
        response.originalFile = originalFile;
        response.proposals = proposals;
        return response;
    }

    class Response
    extends Get.Response {
        String prismLang;
        String originalData;
        String originalFile;
        List<Proposal> proposals;

        Response() {
        }
    }
}

