/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.events;

import java.util.List;
import org.vavilon.app.events.EventsUtils;
import org.vavilon.app.events.model.Transition;
import org.vavilon.gdb.BigMap;
import org.vavilon.gdb.MultiTop;
import org.vavilon.servers.model.Get;
import org.vavilon.token.utils.Request;

public class Recommendations
extends Get {
    public static final String MODULE = "recs";
    public static final BigMap<Transition> countsByDomain = new BigMap<Transition>(EventsUtils.APP + "/" + "recs", "countsByWindow", Transition.class);
    public static final MultiTop<Transition> topByWindow = new MultiTop<Transition>(EventsUtils.APP + "/" + "recs", "recs", countsByDomain, (a, b) -> Long.compare(b.count, a.count), 10);

    public static void addTransition(String from, String to) {
        if (from == null) {
            return;
        }
        if (to == null) {
            return;
        }
        if (from.equals(to)) {
            return;
        }
        String key = from + ":" + to;
        Transition transition = countsByDomain.get(key);
        if (transition == null) {
            transition = new Transition(to, 0L);
        }
        ++transition.count;
        countsByDomain.put(key, transition);
        topByWindow.put(from, transition);
    }

    @Override
    public Response get() {
        String from = this.getRequired("from");
        Response response = new Response();
        response.recommended = topByWindow.getTop(from);
        return response;
    }

    public static Response request(String from) {
        return (Response)new Recommendations().run(null, Request.map("from", from));
    }

    public class Response
    extends Get.Response {
        public List<Transition> recommended;
    }
}

