/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange;

import org.vavilon.app.exchange.LiquidityBot;
import org.vavilon.app.exchange.Place;
import org.vavilon.servers.model.Get;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Utils;

public class LiquidityAdd
extends Get {
    @Override
    public Get.Response get() {
        String domain = this.getRequired("domain");
        String address = this.getAddress("address");
        Double gas_amount = this.getDouble("gas_amount");
        String gas_pass = this.getRequired("gas_pass");
        String token_pass = this.getRequired("token_pass");
        gas_amount = Utils.round(gas_amount);
        Double token_amount = Utils.round(gas_amount / Place.getMarketPrice(domain));
        if (gas_amount <= 0.0) {
            Utils.error("gas amount less or equals than 0");
        }
        if (token_amount <= 0.0) {
            Utils.error("token amount less or equals than 0");
        }
        if (Send.getBalanceOrZero("usdt", address) < gas_amount) {
            Utils.error("gas not enough");
        }
        if (Send.getBalanceOrZero(domain, address) < token_amount) {
            Utils.error("token not enough");
        }
        Send.request("usdt", address, LiquidityBot.liquidityBots.get((Object)domain).bot_address, gas_amount, gas_pass, null);
        Send.request(domain, address, LiquidityBot.liquidityBots.get((Object)domain).bot_address, token_amount, token_pass, null);
        return new Get.Response();
    }

    public static void request(String domain, String address, Double gas_amount, String gas_pass, String token_pass) {
        new LiquidityAdd().run(null, Request.map("domain", domain, "address", address, "gas_amount", gas_amount, "gas_pass", gas_pass, "token_pass", token_pass));
    }
}

