/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vavilon.app.exchange.CancelAll;
import org.vavilon.app.exchange.Place;
import org.vavilon.app.exchange.bot.HedgeBot;
import org.vavilon.servers.WssServer;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.base.model.Transaction;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class LiquidityBot
extends Utils
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", LiquidityBot.class.getSimpleName() + "_seed");
    public static Map<String, LiquidityBot> liquidityBots = new HashMap<String, LiquidityBot>();
    public static final double VOLATILITY = 5.0E-4;
    public String bot_password;
    public String bot_address;
    private String domain;
    private final InfiniteTimer secTimer = new InfiniteTimer(this, Duration.ofSeconds(1L), Duration.ofDays(30L));

    public LiquidityBot(String domain) {
        if (domain.equals("usdt")) {
            LiquidityBot.error("gas domain is not available");
        }
        this.domain = domain;
        this.bot_password = LiquidityBot.hash(SEED + " " + domain);
        this.bot_address = Send.hashAddress(this.bot_password);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        } else {
            this.cashBackAfterRestart();
            Place.incBalance("usdt", this.bot_address, Send.getAccount((String)"usdt", (String)this.bot_address).balance);
            Place.incBalance(domain, this.bot_address, Send.getAccount((String)domain, (String)this.bot_address).balance);
        }
    }

    public void cashBackAfterRestart() {
        this.cashBackSellAfterRestart();
        this.cashBackBuyAfterRestart();
    }

    public void cashBackSellAfterRestart() {
        HashMap<String, Transaction> lastSellUserTokens = new HashMap<String, Transaction>();
        for (Transaction transaction : Send.getTrans(this.domain, this.bot_address, null, 0L, 1000L)) {
            if (!transaction.to.equals(this.bot_address) || lastSellUserTokens.containsKey(transaction.from)) continue;
            lastSellUserTokens.put(transaction.from, transaction);
        }
        HashMap<String, Transaction> lastSellUserGas = new HashMap<String, Transaction>();
        for (Transaction tran : Send.getTrans("usdt", this.bot_address, null, 0L, 1000L)) {
            if (!tran.from.equals(this.bot_address) || lastSellUserGas.containsKey(tran.to)) continue;
            lastSellUserGas.put(tran.to, tran);
        }
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        for (String userAddress : lastSellUserTokens.keySet()) {
            Transaction gasTran = (Transaction)lastSellUserGas.get(userAddress);
            Transaction tokenTran = (Transaction)lastSellUserTokens.get(userAddress);
            if (gasTran != null && tokenTran.time <= gasTran.time) continue;
            arrayList.add((Transaction)lastSellUserTokens.get(userAddress));
        }
        for (Transaction tran : arrayList) {
            try {
                Send.request(this.domain, this.bot_address, tran.from, tran.amount, Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
                System.out.println("Refunded");
            }
            catch (Exception e) {
                System.err.println("Failed to refund sell");
            }
        }
    }

    public void cashBackBuyAfterRestart() {
        HashMap<String, Transaction> lastBuyUserGas = new HashMap<String, Transaction>();
        for (Transaction transaction : Send.getTrans("usdt", this.bot_address, null, 0L, 1000L)) {
            if (!transaction.to.equals(this.bot_address) || lastBuyUserGas.containsKey(transaction.from)) continue;
            lastBuyUserGas.put(transaction.from, transaction);
        }
        HashMap<String, Transaction> lastBuyUserTokens = new HashMap<String, Transaction>();
        for (Transaction tran : Send.getTrans(this.domain, this.bot_address, null, 0L, 1000L)) {
            if (!tran.from.equals(this.bot_address) || lastBuyUserTokens.containsKey(tran.to)) continue;
            lastBuyUserTokens.put(tran.to, tran);
        }
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        for (String userAddress : lastBuyUserGas.keySet()) {
            Transaction gasTran = (Transaction)lastBuyUserGas.get(userAddress);
            Transaction tokenTran = (Transaction)lastBuyUserTokens.get(userAddress);
            if (tokenTran != null && gasTran.time <= tokenTran.time) continue;
            arrayList.add(gasTran);
        }
        for (Transaction tran : arrayList) {
            try {
                Send.request("usdt", this.bot_address, tran.from, tran.amount, Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
                System.out.println("Refunded buy");
            }
            catch (Exception e) {
                System.err.println("Failed to refund buy");
            }
        }
    }

    public void refresh() {
        this.secTimer.restart();
    }

    @Override
    public void onTimer() {
        try {
            double gasBalance = Place.getExchangeBalance("usdt", this.bot_address);
            if (gasBalance < 0.01) {
                return;
            }
            double tokenBalance = Place.getExchangeBalance(this.domain, this.bot_address);
            CancelAll.request(this.domain, this.bot_address);
            Token token = Send.getToken(this.domain);
            if (token.isWrapped()) {
                if (HedgeBot.rates.containsKey(this.domain)) {
                    boolean isSell = LiquidityBot.random() % 2 == 0;
                    double price = LiquidityBot.round(HedgeBot.rates.get(this.domain) * (1.0 + (double)(isSell ? -1 : 1) * 5.0E-4));
                    this.fillOrderbook(this.domain, price, 2.0, gasBalance, 7);
                }
            } else {
                boolean isSell = LiquidityBot.random() % 2 == 0;
                double oldPrice = Place.getMarketPrice(this.domain);
                if (oldPrice == 0.0) {
                    oldPrice = tokenBalance / gasBalance;
                }
                double nextPrice = LiquidityBot.round(oldPrice * (1.0 + (double)(isSell ? -1 : 1) * 5.0E-4));
                double needPrice = gasBalance / tokenBalance;
                double spredInGas = gasBalance / 10.0;
                nextPrice += (needPrice - nextPrice) * 0.1;
                this.fillOrderbook(this.domain, nextPrice, 2.0, spredInGas, 7);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error: " + e.getMessage());
        }
        WssServer.broadcast("orderbook:" + this.domain, Request.map("x", "1"));
    }

    void fillOrderbook(String domain, double price, double rangePercent, double gasAmount, int orderCount) {
        this.placeRange(domain, price, rangePercent, gasAmount, orderCount, true);
        this.placeRange(domain, price, rangePercent, gasAmount, orderCount, false);
    }

    public List<Double> steps(double price, double percent, int count) {
        ArrayList<Double> result = new ArrayList<Double>();
        double stepDiff = price * percent / 100.0 / (double)count;
        stepDiff = percent > 0.0 ? Math.max(1.0E-4, stepDiff) : Math.min(-1.0E-4, stepDiff);
        for (int i = 0; i < count; ++i) {
            double step = LiquidityBot.round(price + stepDiff * (double)i);
            if (step < 1.0E-4) {
                step = 1.0E-4;
            }
            result.add(step);
        }
        return result;
    }

    public void placeRange(String domain, double price, double rangePercent, double gasAmount, int orderCount, boolean isSell) {
        for (Double stepPrice : this.steps(price, (double)(isSell ? 1 : -1) * rangePercent, orderCount)) {
            double stepAmount = Math.max(1.0E-4, LiquidityBot.round(gasAmount / (double)orderCount / stepPrice));
            double stepTotal = LiquidityBot.round(stepPrice * stepAmount);
            try {
                Place.place(domain, isSell, stepPrice, stepAmount, stepTotal, this.bot_address);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isLiquidityBotAddress(String domain, String address) {
        return liquidityBots.containsKey(domain) && LiquidityBot.liquidityBots.get((Object)domain).bot_address.equals(address);
    }
}

