/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange;

import java.util.List;
import org.vavilon.app.exchange.Place;
import org.vavilon.app.exchange.model.PriceLevel;
import org.vavilon.servers.model.Get;
import org.vavilon.token.utils.Utils;

public class OrderBook
extends Get {
    public static void fillAdditionalData(List<PriceLevel> levels) {
        double sum = 0.0;
        for (PriceLevel level : levels) {
            sum += level.amount;
        }
        double accumulateAmount = 0.0;
        for (PriceLevel level : levels) {
            level.price = Utils.round(level.price);
            level.amount = Utils.round(accumulateAmount += level.amount);
            level.percent = Utils.round(accumulateAmount / sum * 100.0);
        }
    }

    @Override
    public Response get() {
        String domain = this.getRequired("domain");
        List<PriceLevel> sellLevels = Place.getPriceLevels(domain, true, 6);
        List<PriceLevel> buyLevels = Place.getPriceLevels(domain, false, 6);
        OrderBook.fillAdditionalData(sellLevels);
        OrderBook.fillAdditionalData(buyLevels);
        Response response = new Response();
        response.sell = sellLevels;
        response.buy = buyLevels;
        return response;
    }

    class Response
    extends Get.Response {
        public List<PriceLevel> sell;
        public List<PriceLevel> buy;

        Response() {
        }
    }
}

