/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange.bot;

import org.vavilon.app.exchange.LiquidityAdd;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class LiquidityPump
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", LiquidityPump.class.getSimpleName() + "_seed");
    public String bot_password;
    public String bot_address;
    private String domain;
    private double portionPercent;

    public LiquidityPump(String domain, double portionPercent) {
        this.domain = domain;
        this.portionPercent = portionPercent;
        this.bot_password = Utils.hash(SEED + " " + domain);
        this.bot_address = Send.hashAddress(this.bot_password);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        }
    }

    @Override
    public void onTimer() {
        try {
            LiquidityAdd.request("vavilon", this.bot_address, Utils.round(Send.getBalanceOrZero("usdt", this.bot_address) * this.portionPercent / 100.0), Send.tokenPass("usdt", this.bot_address, this.bot_password), Send.tokenPass(this.domain, this.bot_address, this.bot_password));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

