/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange.bot;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.vavilon.app.exchange.CancelAll;
import org.vavilon.app.exchange.ExchangeUtils;
import org.vavilon.app.exchange.LiquidityBot;
import org.vavilon.app.exchange.Place;
import org.vavilon.charts.Chart;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Request;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class PricePump
extends ExchangeUtils
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", PricePump.class.getSimpleName() + "_seed");
    public static Map<String, PricePump> bots = new HashMap<String, PricePump>();
    public static final Map<String, String> botAddressToDomain = new HashMap<String, String>();
    public String bot_password;
    public String bot_address;
    private String domain;
    private InfiniteTimer dayTimer;

    public PricePump(String domain) {
        if (!domain.equals("vavilon")) {
            return;
        }
        this.domain = domain;
        this.bot_password = Utils.hash(SEED + " " + domain);
        this.bot_address = PricePump.hashAddress(this.bot_password);
        botAddressToDomain.put(this.bot_address, domain);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        }
        this.dayTimer = new InfiniteTimer(this, Duration.ofHours(1L), Duration.ofDays(30L));
    }

    public void refresh() {
        if (this.dayTimer != null) {
            this.dayTimer.restart();
        }
    }

    @Override
    public void onTimer() {
        try {
            double price;
            new CancelAll().run("", Request.map("domain", this.domain, "address", this.bot_address));
            LiquidityBot bot = LiquidityBot.liquidityBots.get(this.domain);
            double change1h = Chart.getChartChange1hPercent("exchange", this.domain + "_price");
            double botGas = Send.getBalance("usdt", this.bot_address);
            double botTokens = Send.getBalance(this.domain, this.bot_address);
            double exchangeGas = Send.getBalance("usdt", bot.bot_address);
            double exchangeTokens = Send.getBalance(this.domain, bot.bot_address);
            double d = price = exchangeTokens == 0.0 ? 1.0 : exchangeGas / exchangeTokens;
            if (exchangeGas < 1.0 || botGas < 1.0) {
                return;
            }
            double changeBorder = 0.001 * (botGas / (price * botTokens)) - 5.0E-4;
            if (change1h >= -changeBorder) {
                double targetPrice = price * (100.0 + (3.0 - change1h)) / 100.0;
                double tokenAmount = (exchangeGas - targetPrice * exchangeTokens) / (targetPrice * 2.0);
                double buyAmount = Math.abs(tokenAmount) * price;
                Place.buy(this.domain, Utils.round(targetPrice), Utils.round(buyAmount), this.bot_address);
                Send.request("usdt", this.bot_address, bot.bot_address, Utils.round(buyAmount), Send.tokenPass("usdt", this.bot_address, this.bot_password), null);
            } else {
                Place.sell(this.domain, Utils.round(price * 0.97), Utils.round(botTokens * 0.1), this.bot_address);
                Send.request(this.domain, this.bot_address, bot.bot_address, Utils.round(botTokens * 0.1), Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error: " + e.getMessage());
        }
    }

    @Override
    public void run() {
    }
}

