/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.exchange.bot;

import org.vavilon.app.exchange.CancelAll;
import org.vavilon.app.exchange.LiquidityBot;
import org.vavilon.app.exchange.Place;
import org.vavilon.token.base.Send;
import org.vavilon.token.base.model.Token;
import org.vavilon.token.contract.Mint;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Settings;
import org.vavilon.token.utils.Utils;

public class SelfCostBot
implements InfiniteTimer.Callback {
    public static final String SEED = Settings.get("exchange", SelfCostBot.class.getSimpleName() + "_seed");
    public String bot_password;
    public String bot_address;
    private String domain;

    public SelfCostBot(String domain) {
        this.domain = domain;
        this.bot_password = Utils.hash(SEED + " " + domain);
        this.bot_address = Send.hashAddress(this.bot_password);
        if (Send.getAccount(domain, this.bot_address) == null) {
            Send.regAccount("usdt", this.bot_address, this.bot_password);
            Send.regAccount(domain, this.bot_address, this.bot_password);
        }
    }

    @Override
    public void onTimer() throws Exception {
        CancelAll.request(this.domain, this.bot_address);
        double botGasBalance = Send.getBalanceOrZero("usdt", this.bot_address);
        double botTokenBalance = Send.getBalanceOrZero(this.domain, this.bot_address);
        LiquidityBot liquidityBot = LiquidityBot.liquidityBots.get(this.domain);
        Token token = Send.getToken(this.domain);
        double tokenCostPrice = Utils.round(token.getCostPrice() / Mint.calcMintRewardPerMin(this.domain, 20.0));
        double marketPrice = Place.getMarketPrice(this.domain);
        if (marketPrice < tokenCostPrice && botGasBalance > 0.0) {
            double gasAmount = Utils.round(botGasBalance / 10.0);
            Place.buy(this.domain, tokenCostPrice, gasAmount, this.bot_address);
            Send.request("usdt", this.bot_address, liquidityBot.bot_address, gasAmount, Send.tokenPass("usdt", this.bot_address, this.bot_password), null);
        } else if (marketPrice > tokenCostPrice && botTokenBalance > 0.0) {
            double tokenAmount = Utils.round(botTokenBalance / 10.0);
            Place.sell(this.domain, tokenCostPrice, tokenAmount, this.bot_address);
            Send.request(this.domain, this.bot_address, liquidityBot.bot_address, tokenAmount, Send.tokenPass(this.domain, this.bot_address, this.bot_password), null);
        }
    }
}

