/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.miner;

import org.vavilon.app.miner.Miner;
import org.vavilon.app.miner.MinerUtils;
import org.vavilon.app.miner.model.MinerAccount;
import org.vavilon.gdb.model.String64;
import org.vavilon.servers.model.Post;
import org.vavilon.token.base.Send;
import org.vavilon.token.utils.Request;

public class ToggleDomain
extends Post {
    @Override
    public void run() {
        String minerAddress;
        String minerPassword;
        String domain = this.getRequired("domain");
        String address = this.getAddress("address");
        MinerAccount minerAccount = MinerUtils.minerAccountsByAddress.get(address);
        if (minerAccount == null) {
            minerPassword = MinerUtils.hash(MinerUtils.MINER_PASSWORD + address);
            minerAddress = Send.hashAddress(minerPassword);
            Send.regAccount("usdt", minerAddress, minerPassword);
            minerAccount = new MinerAccount(address, minerAddress, null, 1.0E-4);
        }
        if (minerAccount.toggleDomain(domain)) {
            minerPassword = MinerUtils.hash(MinerUtils.MINER_PASSWORD + address);
            minerAddress = Send.hashAddress(minerPassword);
            Send.regAccount(domain, minerAddress, minerPassword);
        }
        MinerUtils.minerAccountsByAddress.put(address, minerAccount);
        MinerUtils.userAddressByMinerAddress.put(minerAccount.minerAddress, new String64(address));
        Miner.activeMinerAccountsByUserAddress.put(address, minerAccount);
        Miner.calcMinerAccount(minerAccount);
    }

    @Override
    public void commit() {
    }

    public static void request(String domain, String address) {
        new ToggleDomain().run(null, Request.map("domain", domain, "address", address));
    }
}

