/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.miner.model;

import org.vavilon.gdb.model.BigArrayCell;
import org.vavilon.gdb.utils.Bytes;
import org.vavilon.token.utils.Utils;

public class MinerAccount
implements BigArrayCell {
    public String userAddress;
    public String minerAddress;
    public String domains;
    public Double tariff;

    public MinerAccount() {
    }

    public MinerAccount(String userAddress, String minerAddress, String domains, Double tariff) {
        this.userAddress = userAddress;
        this.minerAddress = minerAddress;
        this.domains = domains;
        this.tariff = tariff;
    }

    @Override
    public void build(Bytes data) {
        data.addString64(this.userAddress);
        data.addString64(this.minerAddress);
        data.addString128(this.domains);
        data.addDouble(this.tariff);
    }

    @Override
    public void parse(Bytes data) {
        this.userAddress = data.readString64();
        this.minerAddress = data.readString64();
        this.domains = data.readString128();
        this.tariff = data.readDouble();
    }

    public boolean toggleDomain(String domain) {
        String newDomains = Utils.toggle(this.domains, domain);
        boolean isAdded = Utils.isEmpty(this.domains) || newDomains.length() > this.domains.length();
        this.domains = newDomains;
        return isAdded;
    }

    public String[] getDomainList() {
        if (Utils.isEmpty(this.domains)) {
            return new String[0];
        }
        return this.domains.split(",");
    }
}

