/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram;

import java.time.Duration;
import java.util.Calendar;
import java.util.TimeZone;
import org.vavilon.app.telegram.Telegram;
import org.vavilon.app.telegram.TelegramUtils;
import org.vavilon.app.telegram.messages.DifficultyAlert;
import org.vavilon.app.telegram.messages.InactivityAlert;
import org.vavilon.app.telegram.messages.PriceAlert;
import org.vavilon.app.telegram.model.Message;
import org.vavilon.app.telegram.model.MessageFrequency;
import org.vavilon.app.telegram.model.MessagePriority;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.gdb.model.LongCell;
import org.vavilon.token.utils.InfiniteTimer;
import org.vavilon.token.utils.Utils;

public class Messages
implements InfiniteTimer.Callback {
    @Override
    public void onTimer() {
        int i = 1;
        while ((long)i < TelegramUtils.usersByUserId.values.size()) {
            TelegramUser user = (TelegramUser)TelegramUtils.usersByUserId.values.get(i);
            this.checkFiltersAndSend(InactivityAlert.getMessage(user), user);
            this.checkFiltersAndSend(PriceAlert.getMessage(user), user);
            this.checkFiltersAndSend(DifficultyAlert.getMessage(user), user);
            ++i;
        }
    }

    void checkFiltersAndSend(Message message, TelegramUser user) {
        if (message != null && this.isDayTimeAllowed(message.priority, user) && this.isFrequencyAllowed(message.template, message.frequency, user)) {
            Telegram.sendToUser(user, message.template, message.params, true);
        }
    }

    private boolean isDayTimeAllowed(MessagePriority priority, TelegramUser user) {
        Calendar cal = Calendar.getInstance();
        if (user.timezoneOffsetMinutes != 0L) {
            cal.setTimeZone(Messages.getTimeZoneIDFromOffset(user.timezoneOffsetMinutes));
        }
        int hour = cal.get(11);
        int day = cal.get(7);
        boolean isWeekend = day == 7 || day == 1;
        switch (priority) {
            case DAY_TIME: {
                return hour >= 9 && hour < 22;
            }
            case WEEKEND_DAY: {
                return isWeekend && hour >= 9 && hour < 22;
            }
            case FREE_TIME: {
                if (isWeekend) {
                    return hour >= 10 && hour < 22;
                }
                return hour >= 9 && hour < 12 || hour >= 18 && hour < 22;
            }
        }
        return true;
    }

    public static TimeZone getTimeZoneIDFromOffset(long offsetMinutes) {
        long totalMinutes = -offsetMinutes;
        long hours = Math.abs(totalMinutes) / 60L;
        long minutes = Math.abs(totalMinutes) % 60L;
        String sign = totalMinutes >= 0L ? "+" : "-";
        return TimeZone.getTimeZone(String.format("GMT%s%02d:%02d", sign, hours, minutes));
    }

    private boolean isFrequencyAllowed(String template, MessageFrequency frequency, TelegramUser user) {
        LongCell lastTime = TelegramUtils.sentTemplates.get(user.chat_id + ":" + template);
        Duration diff = frequency == MessageFrequency.ONE_IN_MINUTE ? Duration.ofMinutes(1L) : (frequency == MessageFrequency.ONE_IN_HOUR ? Duration.ofHours(1L) : (frequency == MessageFrequency.ONE_IN_DAY ? Duration.ofDays(1L) : (frequency == MessageFrequency.ONE_IN_24H ? Duration.ofHours(24L) : Duration.ofDays(365L))));
        if (lastTime == null) {
            return true;
        }
        return Utils.currentTimeSec() - lastTime.value > diff.getSeconds();
    }
}

