/*
 * Decompiled with CFR 0.152.
 */
package org.vavilon.app.telegram.messages;

import java.util.List;
import org.vavilon.app.telegram.messages.PriceAlert;
import org.vavilon.app.telegram.model.Message;
import org.vavilon.app.telegram.model.MessageFrequency;
import org.vavilon.app.telegram.model.MessagePriority;
import org.vavilon.app.telegram.model.TelegramUser;
import org.vavilon.token.base.model.Account;
import org.vavilon.token.base.model.Token;

public class DifficultyAlert {
    public static Message getMessage(TelegramUser user) {
        try {
            List<Account> accounts = PriceAlert.getTopSubAccounts(user.address);
            Account topAccount = DifficultyAlert.filterByDifficultyBorder(accounts);
            return DifficultyAlert.createMessage(topAccount);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Account filterByDifficultyBorder(List<Account> accounts) {
        Account topAccount = null;
        for (Account account : accounts) {
            if (!(Math.abs(account.token.difficulty24) > DifficultyAlert.change24Border(account.token))) continue;
            topAccount = account;
        }
        return topAccount;
    }

    private static double change24Border(Token token) {
        if (token.difficulty > 10000000L) {
            return 10.0;
        }
        if (token.difficulty > 1000000L) {
            return 20.0;
        }
        if (token.difficulty > 100000L) {
            return 100.0;
        }
        return 300.0;
    }

    private static Message createMessage(Account account) {
        if (account == null) {
            return null;
        }
        return new Message("difficulty_alert", MessagePriority.DAY_TIME, MessageFrequency.ONE_IN_24H, account.token);
    }
}

